/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.melange.resource;

import com.google.common.base.Objects;
import fr.inria.diverse.melange.adapters.ResourceAdapter;
import fr.inria.diverse.melange.resource.MelangeRegistry;
import java.util.List;
import java.util.Map;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

public class MelangeRegistryImpl
implements MelangeRegistry {
    private Map<String, MelangeRegistry.LanguageDescriptor> languageMap = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private Map<String, MelangeRegistry.ModelTypeDescriptor> modelTypeMap = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private static MelangeRegistry INSTANCE = MelangeRegistryImpl.getInstance();

    public static synchronized MelangeRegistry getInstance() {
        if (INSTANCE == null) {
            MelangeRegistryImpl _melangeRegistryImpl = new MelangeRegistryImpl();
            INSTANCE = _melangeRegistryImpl;
        }
        return INSTANCE;
    }

    private MelangeRegistryImpl() {
    }

    @Override
    public Map<String, MelangeRegistry.LanguageDescriptor> getLanguageMap() {
        return this.languageMap;
    }

    @Override
    public Map<String, MelangeRegistry.ModelTypeDescriptor> getModelTypeMap() {
        return this.modelTypeMap;
    }

    @Override
    public MelangeRegistry.LanguageDescriptor getLanguageByIdentifier(String identifier) {
        return this.languageMap.get(identifier);
    }

    @Override
    public MelangeRegistry.LanguageDescriptor getLanguageByUri(final String uri) {
        Functions.Function1<MelangeRegistry.LanguageDescriptor, Boolean> _function = new Functions.Function1<MelangeRegistry.LanguageDescriptor, Boolean>(){

            public Boolean apply(MelangeRegistry.LanguageDescriptor it) {
                String _uri = it.getUri();
                return Objects.equal((Object)_uri, (Object)uri);
            }
        };
        return (MelangeRegistry.LanguageDescriptor)IterableExtensions.findFirst(this.languageMap.values(), (Functions.Function1)_function);
    }

    @Override
    public MelangeRegistry.ModelTypeDescriptor getModelTypeByIdentifier(String identifier) {
        return this.modelTypeMap.get(identifier);
    }

    @Override
    public MelangeRegistry.ModelTypeDescriptor getModelTypeByUri(final String uri) {
        Functions.Function1<MelangeRegistry.ModelTypeDescriptor, Boolean> _function = new Functions.Function1<MelangeRegistry.ModelTypeDescriptor, Boolean>(){

            public Boolean apply(MelangeRegistry.ModelTypeDescriptor it) {
                String _uri = it.getUri();
                return Objects.equal((Object)_uri, (Object)uri);
            }
        };
        return (MelangeRegistry.ModelTypeDescriptor)IterableExtensions.findFirst(this.modelTypeMap.values(), (Functions.Function1)_function);
    }

    @Accessors
    public static class LanguageDescriptorImpl
    implements MelangeRegistry.LanguageDescriptor {
        private String identifier;
        private String description;
        private String uri;
        private String exactType;
        private Map<String, Class<? extends ResourceAdapter>> adapters = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

        public LanguageDescriptorImpl(String i, String d, String u, String e) {
            this.identifier = i;
            this.description = d;
            this.uri = u;
            this.exactType = e;
        }

        @Override
        public Class<? extends ResourceAdapter> getAdapterFor(String mt) {
            return this.adapters.get(mt);
        }

        @Override
        public void addAdapter(String mt, Class<? extends ResourceAdapter> adap) {
            this.adapters.put(mt, adap);
        }

        @Override
        @Pure
        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        @Pure
        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Pure
        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        @Pure
        public String getExactType() {
            return this.exactType;
        }

        public void setExactType(String exactType) {
            this.exactType = exactType;
        }

        @Pure
        public Map<String, Class<? extends ResourceAdapter>> getAdapters() {
            return this.adapters;
        }

        public void setAdapters(Map<String, Class<? extends ResourceAdapter>> adapters) {
            this.adapters = adapters;
        }
    }

    @Accessors
    public static class ModelTypeDescriptorImpl
    implements MelangeRegistry.ModelTypeDescriptor {
        private String identifier;
        private String description;
        private String uri;
        private List<String> superTypes = CollectionLiterals.newArrayList((Object[])new String[0]);

        public ModelTypeDescriptorImpl(String i, String d, String u) {
            this.identifier = i;
            this.description = d;
            this.uri = u;
        }

        @Override
        public void addSuperType(String mt) {
            this.superTypes.add(mt);
        }

        @Override
        @Pure
        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        @Pure
        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Pure
        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        @Pure
        public List<String> getSuperTypes() {
            return this.superTypes;
        }

        public void setSuperTypes(List<String> superTypes) {
            this.superTypes = superTypes;
        }
    }
}

