/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Stack;
import org.eclipse.acceleo.query.ast.And;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.BooleanLiteral;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.Implies;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.NullLiteral;
import org.eclipse.acceleo.query.ast.Or;
import org.eclipse.acceleo.query.ast.RealLiteral;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.SetInExtensionLiteral;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.TypeSetLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.util.AstSwitch;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.EvaluationServices;
import org.eclipse.acceleo.query.runtime.impl.LambdaValue;
import org.eclipse.acceleo.query.runtime.impl.Nothing;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class AstEvaluator
extends AstSwitch<Object> {
    private static final String BAD_PREDICATE_TYPE_MSG = "Conditional's predicate must evaluate to a boolean value but was %s instead.";
    private final Stack<Map<String, Object>> variablesStack;
    private final EvaluationServices services;
    private Diagnostic diagnostic;

    public AstEvaluator(IReadOnlyQueryEnvironment queryEnv) {
        this(new EvaluationServices(queryEnv));
    }

    public AstEvaluator(EvaluationServices services) {
        this.services = services;
        this.variablesStack = new Stack();
    }

    public EvaluationResult eval(Map<String, Object> varDefinitions, Expression ast) {
        this.variablesStack.push(varDefinitions);
        this.diagnostic = new BasicDiagnostic();
        Object result = this.doSwitch(ast);
        this.variablesStack.pop();
        return new EvaluationResult(result, this.diagnostic);
    }

    @Override
    public Object caseBooleanLiteral(BooleanLiteral object) {
        return object.isValue();
    }

    @Override
    public Object caseIntegerLiteral(IntegerLiteral object) {
        return object.getValue();
    }

    @Override
    public Object caseRealLiteral(RealLiteral object) {
        return object.getValue();
    }

    @Override
    public Object caseStringLiteral(StringLiteral object) {
        return object.getValue();
    }

    @Override
    public Object caseTypeLiteral(TypeLiteral object) {
        return object.getValue();
    }

    @Override
    public Object caseCall(Call object) {
        Object result;
        EList<Expression> exprArgs = object.getArguments();
        int argc = exprArgs.size();
        Object[] args = new Object[argc];
        int i = 0;
        for (Expression arg : exprArgs) {
            args[i++] = this.doSwitch(arg);
        }
        switch (object.getType()) {
            case CALLSERVICE: {
                result = this.services.call(object.getServiceName(), args, this.diagnostic);
                break;
            }
            case CALLORAPPLY: {
                result = this.services.callOrApply(object.getServiceName(), args, this.diagnostic);
                break;
            }
            case COLLECTIONCALL: {
                result = this.services.collectionServiceCall(object.getServiceName(), args, this.diagnostic);
                break;
            }
            default: {
                throw new UnsupportedOperationException("should never happen");
            }
        }
        return result;
    }

    @Override
    public Object caseAnd(And object) {
        Object result;
        Object[] args = new Object[2];
        args[0] = this.doSwitch((EObject)object.getArguments().get(0));
        if (args[0] != null && args[0].getClass() == Boolean.class && Boolean.FALSE.equals(args[0])) {
            result = Boolean.FALSE;
        } else {
            args[1] = this.doSwitch((EObject)object.getArguments().get(1));
            result = this.services.call(object.getServiceName(), args, this.diagnostic);
        }
        return result;
    }

    @Override
    public Object caseOr(Or object) {
        Object result;
        Object[] args = new Object[2];
        args[0] = this.doSwitch((EObject)object.getArguments().get(0));
        if (args[0] != null && args[0].getClass() == Boolean.class && Boolean.TRUE.equals(args[0])) {
            result = Boolean.TRUE;
        } else {
            args[1] = this.doSwitch((EObject)object.getArguments().get(1));
            result = this.services.call(object.getServiceName(), args, this.diagnostic);
        }
        return result;
    }

    @Override
    public Object caseImplies(Implies object) {
        Object result;
        Object[] args = new Object[2];
        args[0] = this.doSwitch((EObject)object.getArguments().get(0));
        if (args[0] != null && args[0].getClass() == Boolean.class && Boolean.FALSE.equals(args[0])) {
            result = Boolean.TRUE;
        } else {
            args[1] = this.doSwitch((EObject)object.getArguments().get(1));
            result = this.services.call(object.getServiceName(), args, this.diagnostic);
        }
        return result;
    }

    @Override
    public Object caseVarRef(VarRef object) {
        return this.services.getVariableValue(this.variablesStack.peek(), object.getVariableName(), this.diagnostic);
    }

    @Override
    public Object caseLambda(Lambda object) {
        return new LambdaValue(object, new HashMap<String, Object>(this.variablesStack.peek()), this, this.diagnostic);
    }

    @Override
    public Object caseNullLiteral(NullLiteral object) {
        return null;
    }

    @Override
    public Object caseEnumLiteral(EnumLiteral object) {
        Object result;
        if (object.getLiteral() != null) {
            result = object.getLiteral().getInstance();
        } else {
            Nothing nothing = new Nothing("Invalid enum literal.");
            BasicDiagnostic diag = new BasicDiagnostic(4, "org.eclipse.acceleo.query", 0, nothing.getMessage(), new Object[]{object});
            ((BasicDiagnostic)this.diagnostic).add((Diagnostic)diag);
            result = nothing;
        }
        return result;
    }

    @Override
    public Object caseSetInExtensionLiteral(SetInExtensionLiteral object) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        for (Expression expression : object.getValues()) {
            result.add(this.doSwitch(expression));
        }
        return result;
    }

    @Override
    public Object caseSequenceInExtensionLiteral(SequenceInExtensionLiteral object) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Expression expression : object.getValues()) {
            result.add(this.doSwitch(expression));
        }
        return result;
    }

    @Override
    public Object caseConditional(Conditional object) {
        Object result;
        Object selector = this.doSwitch(object.getPredicate());
        if (selector instanceof Boolean) {
            result = ((Boolean)selector).booleanValue() ? this.doSwitch(object.getTrueBranch()) : this.doSwitch(object.getFalseBranch());
        } else {
            Nothing nothing = new Nothing(String.format(BAD_PREDICATE_TYPE_MSG, selector));
            BasicDiagnostic diag = new BasicDiagnostic(2, "org.eclipse.acceleo.query", 0, nothing.getMessage(), new Object[]{object.getPredicate()});
            ((BasicDiagnostic)this.diagnostic).add((Diagnostic)diag);
            result = nothing;
        }
        return result;
    }

    @Override
    public Object caseLet(Let object) {
        HashMap<String, Object> letEnv = new HashMap<String, Object>(this.variablesStack.peek());
        for (Binding binding : object.getBindings()) {
            letEnv.put(binding.getName(), this.doSwitch(binding.getValue()));
        }
        this.variablesStack.push(letEnv);
        Object result = this.doSwitch(object.getBody());
        this.variablesStack.pop();
        return result;
    }

    @Override
    public Object caseTypeSetLiteral(TypeSetLiteral object) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>(object.getTypes().size());
        for (TypeLiteral type : object.getTypes()) {
            result.add(this.doSwitch(type));
        }
        return result;
    }
}

