/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.AbstractModelManager;
import org.eclipse.pde.internal.core.BinaryRepositoryProvider;
import org.eclipse.pde.internal.core.ModelProviderEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.team.core.RepositoryProvider;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class WorkspaceModelManager<T>
extends AbstractModelManager
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private Map<IProject, T> fModels = null;
    private ArrayList<ModelChange> fChangedModels;
    private final IEclipsePreferences.IPreferenceChangeListener bundleRootChangedListener = this.createBundleRootChangeListener();

    public static boolean isPluginProject(IProject project) {
        if (project == null) {
            return false;
        }
        if (project.isOpen()) {
            return PDEProject.getManifest(project).exists() || PDEProject.getPluginXml(project).exists() || PDEProject.getFragmentXml(project).exists();
        }
        return false;
    }

    public static boolean isFeatureProject(IProject project) {
        return project.isOpen() && PDEProject.getFeatureXml(project).exists();
    }

    public static boolean isBinaryProject(IProject project) {
        try {
            String binary;
            if (project.isOpen() && (binary = project.getPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY)) != null) {
                RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
                return provider == null || provider instanceof BinaryRepositoryProvider;
            }
        }
        catch (CoreException e) {
            PDECore.logException(e);
        }
        return false;
    }

    public static boolean isUnsharedProject(IProject project) {
        return RepositoryProvider.getProvider((IProject)project) == null || WorkspaceModelManager.isBinaryProject(project);
    }

    protected Map<IProject, T> getModelsMap() {
        this.ensureModelsMapCreated();
        return this.fModels;
    }

    private void ensureModelsMapCreated() {
        if (this.fModels == null) {
            this.fModels = Collections.synchronizedMap(new LinkedHashMap());
        }
    }

    protected synchronized void initialize() {
        IProject[] projects;
        if (this.fModels != null) {
            return;
        }
        this.ensureModelsMapCreated();
        IProject[] iProjectArray = projects = PDECore.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (this.isInterestingProject(project)) {
                this.createModel(project, false);
            }
            ++n2;
        }
        this.addListeners();
    }

    protected abstract boolean isInterestingProject(IProject var1);

    protected abstract void createModel(IProject var1, boolean var2);

    protected abstract T removeModel(IProject var1);

    protected void addListeners() {
        IWorkspace workspace = PDECore.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this, 3);
        if (this.bundleRootChangedListener != null) {
            Arrays.stream(workspace.getRoot().getProjects()).forEach(this::addBundleRootChangedListener);
        }
    }

    @Override
    protected void removeListeners() {
        PDECore.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.removeListeners();
    }

    protected T getModel(IProject project) {
        this.initialize();
        return this.fModels.get(project);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                this.handleResourceDelta(event.getDelta());
                this.processModelChanges();
                break;
            }
            case 2: {
                this.removeModel((IProject)event.getResource());
                this.processModelChanges();
            }
        }
    }

    private void handleResourceDelta(IResourceDelta delta) {
        try {
            delta.accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            PDECore.logException(e);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta != null) {
            IResource resource = delta.getResource();
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    boolean addedOrOpened;
                    IProject project = (IProject)resource;
                    boolean bl = addedOrOpened = delta.getKind() == 1 || (delta.getFlags() & 0x4000) != 0;
                    if (addedOrOpened && this.bundleRootChangedListener != null) {
                        this.addBundleRootChangedListener(project);
                    }
                    if (this.isInterestingProject(project) && addedOrOpened) {
                        this.createModel(project, true);
                        return false;
                    }
                    if (delta.getKind() == 2) {
                        this.removeModel(project);
                        return false;
                    }
                    return true;
                }
                case 2: {
                    return this.isInterestingFolder((IFolder)resource);
                }
                case 1: {
                    if (!this.isContentChange(delta)) break;
                    this.handleFileDelta(delta);
                    return false;
                }
            }
        }
        return false;
    }

    private void addBundleRootChangedListener(IProject project) {
        IEclipsePreferences pdeNode = new ProjectScope(project).getNode("org.eclipse.pde.core");
        pdeNode.addPreferenceChangeListener(this.bundleRootChangedListener);
    }

    protected IEclipsePreferences.IPreferenceChangeListener createBundleRootChangeListener() {
        return e -> {
            if ("BUNDLE_ROOT_PATH".equals(e.getKey()) && !WorkspaceModelManager.isInRemovedBranch(e.getNode())) {
                String projectName = Path.forPosix((String)e.getNode().absolutePath()).segment(1);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (this.getModel(project) != null) {
                    this.removeModel(project);
                }
                this.createModel(project, true);
            }
        };
    }

    private static boolean isInRemovedBranch(Preferences node) {
        return !Stream.iterate(node, Objects::nonNull, Preferences::parent).allMatch(n -> {
            try {
                return n.nodeExists("");
            }
            catch (BackingStoreException backingStoreException) {
                return false;
            }
        });
    }

    private boolean isContentChange(IResourceDelta delta) {
        int kind = delta.getKind();
        return kind == 1 || kind == 2 || kind == 4 && (delta.getFlags() & 0x100) != 0;
    }

    protected boolean isInterestingFolder(IFolder folder) {
        return false;
    }

    protected abstract void handleFileDelta(IResourceDelta var1);

    protected void addChange(IModel model, int eventType) {
        if (model != null) {
            ModelChange change;
            if (this.fChangedModels == null) {
                this.fChangedModels = new ArrayList();
            }
            if (!this.fChangedModels.contains(change = new ModelChange(model, eventType))) {
                this.fChangedModels.add(change);
            }
        }
    }

    protected void processModelChanges() {
        this.processModelChanges("org.eclipse.pde.core.IModelProviderEvent", this.fChangedModels);
        this.fChangedModels = null;
    }

    protected void processModelChanges(String changeId, ArrayList<ModelChange> changedModels) {
        if (changedModels == null) {
            return;
        }
        if (changedModels.isEmpty()) {
            return;
        }
        ArrayList<IModel> added = new ArrayList<IModel>();
        ArrayList<IModel> removed = new ArrayList<IModel>();
        ArrayList<IModel> changed = new ArrayList<IModel>();
        ListIterator<ModelChange> li = changedModels.listIterator();
        while (li.hasNext()) {
            ModelChange change = li.next();
            switch (change.type) {
                case 1: {
                    added.add(change.model);
                    break;
                }
                case 2: {
                    removed.add(change.model);
                    break;
                }
                case 4: {
                    changed.add(change.model);
                }
            }
        }
        int type = 0;
        if (!added.isEmpty()) {
            type |= 1;
        }
        if (!removed.isEmpty()) {
            type |= 2;
        }
        if (!changed.isEmpty()) {
            type |= 4;
        }
        if (type != 0) {
            this.createAndFireEvent(changeId, type, added, removed, changed);
        }
    }

    protected void loadModel(IModel model, boolean reload) {
        IFile file = (IFile)model.getUnderlyingResource();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedInputStream stream = new BufferedInputStream(file.getContents(true));){
                if (reload) {
                    model.reload(stream, false);
                } else {
                    model.load(stream, false);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            PDECore.logException(e);
        }
    }

    protected void createAndFireEvent(String eventId, int type, Collection<IModel> added, Collection<IModel> removed, Collection<IModel> changed) {
        if (eventId.equals("org.eclipse.pde.core.IModelProviderEvent")) {
            ModelProviderEvent event = new ModelProviderEvent(this, type, added.toArray(new IModel[added.size()]), removed.toArray(new IModel[removed.size()]), changed.toArray(new IModel[changed.size()]));
            this.fireModelProviderEvent(event);
        }
    }

    static class ModelChange {
        IModel model;
        int type;

        public ModelChange(IModel model, int type) {
            this.model = model;
            this.type = type;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ModelChange) {
                ModelChange change = (ModelChange)obj;
                IProject project = change.model.getUnderlyingResource().getProject();
                int type = change.type;
                return this.model.getUnderlyingResource().getProject().equals((Object)project) && this.type == type;
            }
            return false;
        }
    }
}

