/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.commons;

import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.xtext.util.MergeableManifest;

public class ManifestUtil {
    private static MergeableManifest createMergableManifest(IResource manifestFile) throws IOException, CoreException {
        try (InputStream originalManifest = ((IFile)manifestFile).getContents();){
            MergeableManifest mergeableManifest = new MergeableManifest(originalManifest);
            return mergeableManifest;
        }
    }

    public static boolean addToPluginManifest(IProject project, IProgressMonitor monitor, String pluginToAdd) throws IOException, CoreException {
        IResource manifestFile = project.findMember("META-INF/MANIFEST.MF");
        if (manifestFile != null && manifestFile.isAccessible() && !manifestFile.getResourceAttributes().isReadOnly() && manifestFile instanceof IFile) {
            OutputStream output = null;
            InputStream input = null;
            try {
                MergeableManifest manifest = ManifestUtil.createMergableManifest(manifestFile);
                ArrayList<String> plunginsToAdd = new ArrayList<String>();
                plunginsToAdd.add(pluginToAdd);
                manifest.addRequiredBundles((Set)Sets.newHashSet(plunginsToAdd));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                output = new BufferedOutputStream(out);
                manifest.write(output);
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                input = new BufferedInputStream(in);
                ((IFile)manifestFile).setContents(input, true, true, monitor);
                return true;
            }
            finally {
                if (output != null) {
                    output.close();
                }
                if (input != null) {
                    input.close();
                }
            }
        }
        return false;
    }

    public static boolean setRequiredExecutionEnvironmentToPluginManifest(IProject project, IProgressMonitor monitor, String requiredExecutionEnvironment) throws IOException, CoreException {
        IResource manifestFile = project.findMember("META-INF/MANIFEST.MF");
        if (manifestFile != null && manifestFile.isAccessible() && !manifestFile.getResourceAttributes().isReadOnly() && manifestFile instanceof IFile) {
            OutputStream output = null;
            InputStream input = null;
            try {
                MergeableManifest manifest = ManifestUtil.createMergableManifest(manifestFile);
                MergeableManifest.OrderAwareAttributes atts = manifest.getMainAttributes();
                atts.putValue("Bundle-RequiredExecutionEnvironment", requiredExecutionEnvironment);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                output = new BufferedOutputStream(out);
                manifest.write(output);
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                input = new BufferedInputStream(in);
                ((IFile)manifestFile).setContents(input, true, true, monitor);
                return true;
            }
            finally {
                if (output != null) {
                    output.close();
                }
                if (input != null) {
                    input.close();
                }
            }
        }
        return false;
    }
}

