/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

@SuppressWarnings("all")
public abstract class ModelChange {
  @Accessors({ AccessorType.PROTECTED_SETTER, AccessorType.PUBLIC_GETTER })
  private EObject changedObject;

  public ModelChange(final EObject changedObject) {
    this.changedObject = changedObject;
  }

  @Pure
  public EObject getChangedObject() {
    return this.changedObject;
  }

  protected void setChangedObject(final EObject changedObject) {
    this.changedObject = changedObject;
  }
}
