/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.LifecycleMappingDiscoveryRequest;
import org.eclipse.m2e.core.ui.internal.wizards.LifecycleMappingDiscoveryHelper;
import org.eclipse.m2e.core.ui.internal.wizards.MavenDiscoveryProposalWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class MappingDiscoveryJob
extends WorkspaceJob {
    private final Collection<IProject> projects;

    public MappingDiscoveryJob(Collection<IProject> projects) {
        super("Discover lifecycle mappings");
        this.projects = projects;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        LifecycleMappingDiscoveryRequest discoveryRequest = LifecycleMappingDiscoveryHelper.createLifecycleMappingDiscoveryRequest(this.projects, monitor);
        if (discoveryRequest.isMappingComplete()) {
            return Status.OK_STATUS;
        }
        this.discoverProposals(discoveryRequest, monitor);
        this.openProposalWizard(this.projects, discoveryRequest);
        return Status.OK_STATUS;
    }

    protected void discoverProposals(LifecycleMappingDiscoveryRequest discoveryRequest, IProgressMonitor monitor) throws CoreException {
        LifecycleMappingDiscoveryHelper.discoverProposals(discoveryRequest, monitor);
    }

    protected void openProposalWizard(Collection<IProject> projects, LifecycleMappingDiscoveryRequest discoveryRequest) {
        MavenDiscoveryProposalWizard proposalWizard = new MavenDiscoveryProposalWizard(projects, discoveryRequest);
        proposalWizard.init(null, null);
        Display.getDefault().asyncExec(() -> {
            IWorkbench workbench = PlatformUI.getWorkbench();
            WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)proposalWizard);
            dialog.open();
        });
    }
}

