/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.wizard.wizards;

import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.utils.pluginhelpers.PluginHelpers;
import fr.inria.aoste.timesquare.wizard.Activator;
import fr.inria.aoste.timesquare.wizard.wizards.AsbtractWizardPage;
import fr.inria.aoste.timesquare.wizard.wizards.ResourceSelectionWizardPage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Bundle;

public abstract class AbstractNewWizard
extends Wizard
implements INewWizard {
    protected AsbtractWizardPage firstPage;
    protected IStructuredSelection selection;
    protected String title;
    protected static DateFormat dateFormat = new SimpleDateFormat("E MMMMM d yyyy  hh:mm:ss z ");
    private ResourceSelectionWizardPage importedResourceSelectionWizardPage = null;

    public AbstractNewWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public final void addPages() {
        this.firstPage = this.createNewFileFirstWizardPage(this.selection);
        this.addPage((IWizardPage)this.firstPage);
        this.importedResourceSelectionWizardPage = this.createImportSelectionWizardPage();
        if (this.importedResourceSelectionWizardPage != null) {
            this.addPage(this.importedResourceSelectionWizardPage);
        }
    }

    protected abstract AsbtractWizardPage createNewFileFirstWizardPage(IStructuredSelection var1);

    protected ResourceSelectionWizardPage createImportSelectionWizardPage() {
        return null;
    }

    public boolean performFinish() {
        final String containerName = this.firstPage.getContainerFullPath().toOSString();
        final String fileName = this.firstPage.getFileName();
        final List<Object> selectionlib = this.importedResourceSelectionWizardPage != null ? this.importedResourceSelectionWizardPage.getSelection() : null;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        AbstractNewWizard.this.doFinish(containerName, fileName, selectionlib, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, List<Object> selectionlib, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            StringBuffer imports = this.generateImportStatements(container, selectionlib);
            InputStream stream = this.openContentStream(fileName, imports.toString());
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
        monitor.worked(1);
    }

    protected abstract StringBuffer generateImportStatements(IContainer var1, List<Object> var2);

    protected abstract InputStream openContentStream(String var1, String var2);

    public String updateTemplate(String contents, String rootName, String imports) {
        contents = contents.replace("%date%", dateFormat.format(new Date()));
        contents = contents.replace("%author%", System.getProperty("user.name"));
        contents = contents.replace("%rootname%", rootName);
        contents = contents.replace("%import%", imports);
        return contents;
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "fr.inria.aoste.timesquare.wizard", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle(this.title);
        this.setDefaultPageImageDescriptor(null);
    }

    public IFile getFile() {
        return this.firstPage.getFile();
    }

    public String readfile(String s, Bundle bundle) {
        String content;
        block14: {
            content = "";
            BufferedReader buffer = null;
            try {
                try {
                    ErrorConsole.println((String)(s + " : "));
                    if (bundle == null) {
                        bundle = Activator.getDefault().getBundle();
                    }
                    URL url = PluginHelpers.getInstallUrl((Bundle)bundle, (String)s);
                    InputStream is = url.openStream();
                    InputStreamReader streamReader = new InputStreamReader(is);
                    StringWriter writer = new StringWriter();
                    buffer = new BufferedReader(streamReader);
                    String line = "";
                    while ((line = buffer.readLine()) != null) {
                        writer.write(line);
                        writer.write("\n");
                    }
                    content = writer.toString();
                }
                catch (Throwable e) {
                    ErrorConsole.printError((Throwable)e, (String)("Fail copy file :" + s));
                    if (buffer == null) break block14;
                    try {
                        buffer.close();
                    }
                    catch (Throwable e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return content;
    }
}

