/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.markup;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;

public abstract class MarkupLanguageProvider {
    public final Set<MarkupLanguage> getMarkupLanguages() {
        ImmutableSet languages = ImmutableSet.copyOf((Collection)Objects.requireNonNull(this.loadMarkupLanguages(), "loadMarkupLanguages() must not return null"));
        this.assertLanguageNames((Set<MarkupLanguage>)languages);
        return languages;
    }

    private void assertLanguageNames(Set<MarkupLanguage> languages) {
        HashSet<String> names = new HashSet<String>();
        for (MarkupLanguage language : languages) {
            Objects.requireNonNull(language.getName(), "Provided languages must have a name");
            Preconditions.checkState((boolean)names.add(language.getName()), (String)"Language name '%s' must not be provided more than once", (Object)language.getName());
        }
    }

    protected abstract Set<MarkupLanguage> loadMarkupLanguages();
}

