/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.metamodel.table.DTargetColumn;
import org.eclipse.sirius.table.metamodel.table.description.TableMapping;
import org.eclipse.sirius.table.metamodel.table.provider.Messages;
import org.eclipse.sirius.table.ui.tools.internal.commands.EMFCommandFactoryUI;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.AbstractLineAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.AbstractTargetColumnAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.AbstractToolAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.CreateLineAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.CreateRepresentationFromRepresentationCreationDescription;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.CreateTargetColumnAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.DeleteLinesAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.DeleteTargetColumnAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.HideColumnAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.HideLinesAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.HideRevealColumnsAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.HideRevealLinesAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.RefreshAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.ShowAllColumnsAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.ShowAllLinesAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.ShowPropertiesViewAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.SortColumnsByLineAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.SortLinesByColumnAction;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.tools.internal.editor.MenuHelper;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationCreationDescription;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationNavigationDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.ui.handlers.IHandlerService;

public class DTableMenuListener
implements IMenuListener {
    private static final String MENU_OPEN_REPRESENTATION_ID = "popup.open";
    private static final String MENU_NEW_REPRESENTATION_ID = "popup.new";
    private static final String MENU_HIDEREVEAL_ID = "popup.hidereveal";
    private static final String MENU_EXPORT_ID = "popup.export";
    private static final String NEW_REPRESENTATION_GROUP_SEPARATOR = "newRepresentation";
    private static final String EXISTING_REPRESENTATION_GROUP_SEPARATOR = "existingRepresentation";
    private static final String VIEWPOINT_GROUP_SEPARATOR = "viewpoint";
    private static final String PROPERTIES_SEPARATOR = "properties";
    private static final String HIDE_SEPARATOR = "hideGroup";
    private final AdapterFactory adapterFactory = DialectUIManager.INSTANCE.createAdapterFactory();
    private DTable dTable;
    private final DTableViewerManager treeViewManager;
    private Map<TableMapping, DeleteTargetColumnAction> mappingToDeleteColumnActions;
    private final DeleteLinesAction deleteLinesAction;
    private Map<TableMapping, List<AbstractToolAction>> mappingToCreateActions;
    private List<AbstractToolAction> createActionsForTable;
    private final HideLinesAction hideLineAction;
    private final ShowAllLinesAction showAllLinesAction;
    private final HideColumnAction hideColumnAction;
    private final ShowAllColumnsAction showAllColumnsAction;
    private final RefreshAction refreshAction;
    private final ShowPropertiesViewAction showPropertiesViewAction;
    private final SortLinesByColumnAction sortLinesByColumnAction;
    private final SortColumnsByLineAction sortColumnsByLineAction;
    private final HideRevealColumnsAction hideRevealColumnsAction;
    private final HideRevealLinesAction hideRevealLinesAction;

    public DTableMenuListener(DTable table, DTableViewerManager treeViewManager, Map<TableMapping, List<AbstractToolAction>> mappingToCreateActions, Map<TableMapping, DeleteTargetColumnAction> mappingToDeleteColumnActions, List<AbstractToolAction> createActionsForTable) {
        this.dTable = table;
        this.treeViewManager = treeViewManager;
        this.setMappingToCreateActions(mappingToCreateActions);
        this.setMappingToDeleteActions(mappingToDeleteColumnActions);
        this.setCreateActionsForTable(createActionsForTable);
        this.deleteLinesAction = new DeleteLinesAction(treeViewManager.getEditingDomain(), treeViewManager.getTableCommandFactory());
        this.hideLineAction = new HideLinesAction(this.dTable, treeViewManager.getEditingDomain(), treeViewManager.getTableCommandFactory());
        this.showAllLinesAction = new ShowAllLinesAction(this.dTable, treeViewManager.getEditingDomain(), treeViewManager.getTableCommandFactory());
        this.hideColumnAction = new HideColumnAction(this.dTable, treeViewManager.getEditingDomain(), treeViewManager.getTableCommandFactory());
        this.showAllColumnsAction = new ShowAllColumnsAction(this.dTable, treeViewManager.getEditingDomain(), treeViewManager.getTableCommandFactory());
        this.refreshAction = new RefreshAction(treeViewManager.getEditor());
        this.showPropertiesViewAction = new ShowPropertiesViewAction();
        this.sortLinesByColumnAction = new SortLinesByColumnAction(treeViewManager.getEditingDomain());
        this.sortColumnsByLineAction = new SortColumnsByLineAction(treeViewManager.getEditingDomain());
        this.hideRevealColumnsAction = new HideRevealColumnsAction(this.dTable, treeViewManager.getEditingDomain(), treeViewManager.getTableCommandFactory());
        this.hideRevealLinesAction = new HideRevealLinesAction(this.dTable, treeViewManager.getEditingDomain(), treeViewManager.getTableCommandFactory(), (TreeViewer)treeViewManager.getTreeViewer());
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.treeViewManager.fillMenu();
        this.addOpenRepresentationMenu(manager);
        this.addNewRepresentationMenu(manager);
        manager.add((IContributionItem)new Separator());
        this.addRefreshMenu(manager);
        manager.add((IContributionItem)new Separator());
        this.addSortMenu(manager);
        manager.add((IContributionItem)new Separator());
        this.addHideRevealMenu(manager);
        manager.add((IContributionItem)new Separator(HIDE_SEPARATOR));
        manager.add((IContributionItem)new Separator());
        this.addColumnMenus(manager);
        this.addLineMenus(manager);
        manager.add((IContributionItem)new Separator());
        this.addTableMenus(manager);
        this.addExportMenu(manager);
        manager.add((IContributionItem)new Separator(PROPERTIES_SEPARATOR));
        manager.appendToGroup(PROPERTIES_SEPARATOR, (IAction)this.showPropertiesViewAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void addTableMenus(IMenuManager manager) {
        Collection<DLine> selectedLines = this.treeViewManager.getSelectedLines();
        if (selectedLines != null && !selectedLines.isEmpty()) {
            for (AbstractToolAction abstractToolAction : this.getCreateActionsForTable()) {
                if (abstractToolAction instanceof CreateLineAction) {
                    CreateLineAction createLineAction = (CreateLineAction)abstractToolAction;
                    createLineAction.setTable(this.dTable);
                    if (!createLineAction.canExecute()) continue;
                    manager.add((IAction)createLineAction);
                    continue;
                }
                if (!(abstractToolAction instanceof CreateTargetColumnAction)) continue;
                CreateTargetColumnAction createTargetColumnAction = (CreateTargetColumnAction)abstractToolAction;
                createTargetColumnAction.setTable(this.dTable);
                if (!createTargetColumnAction.canExecute()) continue;
                manager.add((IAction)createTargetColumnAction);
            }
            manager.add((IContributionItem)new Separator());
        }
    }

    private void addOpenRepresentationMenu(IMenuManager manager) {
        MenuManager openMenuManager = new MenuManager(Messages.DTableMenuListener_openMenuName, MENU_OPEN_REPRESENTATION_ID);
        SubContributionItem openMenuItem = new SubContributionItem((IContributionItem)openMenuManager);
        manager.add((IContributionItem)openMenuItem);
        Separator existingGroup = new Separator(EXISTING_REPRESENTATION_GROUP_SEPARATOR);
        openMenuManager.add((IContributionItem)existingGroup);
        Separator openRepresentationGroup = new Separator("openRepresentationGroup");
        openMenuManager.add((IContributionItem)openRepresentationGroup);
        DTableElement currentTableElement = this.getCurrentTableElement();
        if (currentTableElement != null) {
            this.createOpenAction(openMenuItem, (DSemanticDecorator)currentTableElement);
        } else {
            this.createOpenAction(openMenuItem, (DSemanticDecorator)this.dTable);
        }
    }

    private void addNewRepresentationMenu(IMenuManager manager) {
        MenuManager newMenuManager = new MenuManager(Messages.DTableMenuListener_newMenuName, MENU_NEW_REPRESENTATION_ID);
        SubContributionItem newMenuItem = new SubContributionItem((IContributionItem)newMenuManager);
        manager.add((IContributionItem)newMenuItem);
        Separator createGroup = new Separator(NEW_REPRESENTATION_GROUP_SEPARATOR);
        newMenuManager.add((IContributionItem)createGroup);
        DTableElement currentTableElement = this.getCurrentTableElement();
        if (currentTableElement instanceof DCell) {
            this.createDetailsActions(currentTableElement, newMenuItem);
        } else if (currentTableElement instanceof DLine) {
            this.createDetailsActions(currentTableElement, newMenuItem);
        }
    }

    private void createOpenAction(SubContributionItem openRepresentation, DSemanticDecorator decorator) {
        EObject semanticElement = decorator.getTarget();
        Session session = SessionManager.INSTANCE.getSession(semanticElement);
        if (session != null) {
            DRepresentationDescriptor representationDescriptor = new DRepresentationQuery((DRepresentation)this.dTable).getRepresentationDescriptor();
            DialectManager.INSTANCE.getAllRepresentationDescriptors(session).stream().filter(rd -> !Objects.equals(rd, representationDescriptor)).filter(repDesc -> Objects.equals(repDesc.getTarget(), semanticElement)).filter(repDesc -> this.isFromActiveViewpoint(session, repDesc.getDescription())).forEach(repDesc -> {
                openRepresentation.setVisible(true);
                ((IMenuManager)openRepresentation.getInnerItem()).appendToGroup(EXISTING_REPRESENTATION_GROUP_SEPARATOR, MenuHelper.buildOpenRepresentationAction((Session)session, (DRepresentationDescriptor)repDesc, (AdapterFactory)this.adapterFactory));
            });
            if (decorator instanceof DRepresentationElement && this.buildOpenRepresentationsMenu((IMenuManager)openRepresentation.getInnerItem(), (DRepresentationElement)decorator, session)) {
                openRepresentation.setVisible(true);
            }
        }
    }

    private boolean buildOpenRepresentationsMenu(IMenuManager open, DRepresentationElement element, Session session) {
        RepresentationElementMapping mapping = element.getMapping();
        if (mapping != null) {
            for (RepresentationNavigationDescription navDesc : mapping.getNavigationDescriptions()) {
                boolean append = true;
                if (!this.isFromActiveViewpoint(session, navDesc.getRepresentationDescription())) {
                    append = false;
                }
                IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(element.getTarget());
                HashMap<Object, Object> variables = new HashMap<Object, Object>();
                variables.put(navDesc.getContainerVariable(), element.getTarget());
                variables.put(navDesc.getContainerViewVariable(), element);
                InitInterpreterVariablesTask init = new InitInterpreterVariablesTask(variables, interpreter, (UICallBack)new EMFCommandFactoryUI());
                init.execute();
                String precondition = navDesc.getPrecondition();
                if (append && !StringUtil.isEmpty((String)precondition)) {
                    append = false;
                    try {
                        append = interpreter.evaluateBoolean(element.getTarget(), navDesc.getPrecondition());
                    }
                    catch (EvaluationException e) {
                        RuntimeLoggerManager.INSTANCE.error((EObject)navDesc, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition(), (Throwable)e);
                    }
                }
                if (!append) continue;
                return MenuHelper.buildOpenRepresentationActions((IMenuManager)open, (IInterpreter)interpreter, (RepresentationNavigationDescription)navDesc, (DRepresentationElement)element, (Session)session, (AdapterFactory)this.adapterFactory);
            }
        }
        return false;
    }

    private DTableElement getCurrentTableElement() {
        DLine result = null;
        Collection<DLine> selectedLines = this.treeViewManager.getSelectedLines();
        if (selectedLines != null && selectedLines.size() == 1) {
            DLine firstSelectedLine = selectedLines.iterator().next();
            if (this.treeViewManager.getActiveColumn() > 0) {
                DColumn column = (DColumn)this.dTable.getColumns().get(this.treeViewManager.getActiveColumn() - 1);
                Option optionalCell = TableHelper.getCell((DLine)firstSelectedLine, (DColumn)column);
                if (optionalCell.some()) {
                    result = (DTableElement)optionalCell.get();
                }
            } else {
                result = firstSelectedLine;
            }
        }
        return result;
    }

    private void addRefreshMenu(IMenuManager manager) {
        manager.add((IAction)this.refreshAction);
    }

    private void addSortMenu(IMenuManager manager) {
        Collection<DLine> selectedLines;
        DColumn activeColumn = null;
        if (this.treeViewManager.getActiveColumn() > 0) {
            activeColumn = (DColumn)this.dTable.getColumns().get(this.treeViewManager.getActiveColumn() - 1);
        }
        this.sortLinesByColumnAction.setColumn(activeColumn);
        if (activeColumn == null) {
            this.sortLinesByColumnAction.setTable(this.dTable);
        }
        if (this.sortLinesByColumnAction.isEnabled()) {
            manager.add((IAction)this.sortLinesByColumnAction);
        }
        if ((selectedLines = this.treeViewManager.getSelectedLines()) != null && !selectedLines.isEmpty()) {
            DLine firstSelectedLine = selectedLines.iterator().next();
            this.sortColumnsByLineAction.setLine(firstSelectedLine);
            if (this.sortColumnsByLineAction.isEnabled()) {
                manager.add((IAction)this.sortColumnsByLineAction);
            }
        }
    }

    private void addExportMenu(IMenuManager manager) {
        MenuManager exportMenuManager = new MenuManager(Messages.DTableMenuListener_exportMenuName, MENU_EXPORT_ID);
        SubContributionItem menuItem = new SubContributionItem((IContributionItem)exportMenuManager);
        menuItem.setVisible(true);
        manager.add((IContributionItem)menuItem);
        exportMenuManager.add((IContributionItem)new Separator(VIEWPOINT_GROUP_SEPARATOR));
        Action action = new Action("CSV", DTableViewerManager.getImageRegistry().getDescriptor("table/export")){

            public void run() {
                IHandlerService handlerService = (IHandlerService)DTableMenuListener.this.treeViewManager.getEditor().getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("org.eclipse.sirius.table.ui.exportToCsv", null);
                }
                catch (CommandException commandException) {
                    throw new RuntimeException(Messages.DTableMenuListener_cvsExportException);
                }
            }
        };
        exportMenuManager.appendToGroup(VIEWPOINT_GROUP_SEPARATOR, (IAction)action);
    }

    private void addHideRevealMenu(IMenuManager manager) {
        MenuManager hideRevealMenuManager = new MenuManager(Messages.DTableMenuListener_showHideMenuName, MENU_HIDEREVEAL_ID);
        SubContributionItem viewpointMenuItem = new SubContributionItem((IContributionItem)hideRevealMenuManager);
        viewpointMenuItem.setVisible(true);
        manager.add((IContributionItem)viewpointMenuItem);
        hideRevealMenuManager.add((IContributionItem)new Separator(VIEWPOINT_GROUP_SEPARATOR));
        DColumn activeColumn = null;
        if (this.treeViewManager.getActiveColumn() > 0) {
            activeColumn = (DColumn)this.dTable.getColumns().get(this.treeViewManager.getActiveColumn() - 1);
        }
        if (activeColumn != null && activeColumn.isVisible()) {
            this.hideColumnAction.setColumn(activeColumn);
            if (this.hideColumnAction.isEnabled()) {
                hideRevealMenuManager.appendToGroup(VIEWPOINT_GROUP_SEPARATOR, (IAction)this.hideColumnAction);
            }
        }
        hideRevealMenuManager.appendToGroup(VIEWPOINT_GROUP_SEPARATOR, (IAction)this.showAllColumnsAction);
        hideRevealMenuManager.appendToGroup(VIEWPOINT_GROUP_SEPARATOR, (IAction)this.hideRevealColumnsAction);
        hideRevealMenuManager.appendToGroup(VIEWPOINT_GROUP_SEPARATOR, (IContributionItem)new Separator());
        Collection<DLine> selectedLines = this.treeViewManager.getSelectedLines();
        if (selectedLines != null && !selectedLines.isEmpty()) {
            Predicate<DLine> isVisible = new Predicate<DLine>(){

                public boolean apply(DLine input) {
                    return input.isVisible();
                }
            };
            Iterable visibleSelection = Iterables.filter(selectedLines, (Predicate)isVisible);
            this.hideLineAction.setLines(Lists.newArrayList((Iterable)visibleSelection));
            if (this.hideLineAction.isEnabled()) {
                hideRevealMenuManager.appendToGroup(VIEWPOINT_GROUP_SEPARATOR, (IAction)this.hideLineAction);
            }
        }
        hideRevealMenuManager.appendToGroup(VIEWPOINT_GROUP_SEPARATOR, (IAction)this.showAllLinesAction);
        hideRevealMenuManager.appendToGroup(VIEWPOINT_GROUP_SEPARATOR, (IAction)this.hideRevealLinesAction);
    }

    private void addColumnMenus(IMenuManager manager) {
        DColumn column;
        if (this.treeViewManager.getActiveColumn() > 0 && (column = (DColumn)this.dTable.getColumns().get(this.treeViewManager.getActiveColumn() - 1)) instanceof DTargetColumn && ((DTargetColumn)column).getOriginMapping() != null) {
            List<AbstractToolAction> createActions;
            DTargetColumn targetColumn = (DTargetColumn)column;
            AbstractTargetColumnAction deleteAction = this.getMappingToDeleteActions().get(targetColumn.getOriginMapping());
            deleteAction.setColumn(targetColumn);
            if (deleteAction.canExecute()) {
                manager.add((IAction)deleteAction);
            }
            if ((createActions = this.getMappingToCreateActions().get(targetColumn.getOriginMapping())) != null) {
                for (AbstractToolAction createAction : createActions) {
                    ((AbstractTargetColumnAction)createAction).setColumn(targetColumn);
                    if (!createAction.canExecute()) continue;
                    manager.add((IAction)createAction);
                }
            }
            manager.add((IContributionItem)new Separator());
        }
    }

    private void addLineMenus(IMenuManager manager) {
        Collection<DLine> selectedLines = this.treeViewManager.getSelectedLines();
        if (selectedLines != null && !selectedLines.isEmpty()) {
            this.addDeleteLinesAction(manager, selectedLines);
            if (selectedLines.size() == 1) {
                DLine firstSelectedLine = selectedLines.iterator().next();
                this.addCreateActions(manager, firstSelectedLine);
            }
            manager.add((IContributionItem)new Separator());
        }
    }

    private void addCreateActions(IMenuManager manager, DLine singleSelectedLine) {
        List<AbstractToolAction> createActions = this.getMappingToCreateActions().get(singleSelectedLine.getOriginMapping());
        if (createActions != null && !createActions.isEmpty()) {
            for (AbstractToolAction createAction : createActions) {
                ((AbstractLineAction)createAction).setLine(singleSelectedLine);
                if (!createAction.canExecute()) continue;
                manager.add((IAction)createAction);
            }
        }
    }

    private void addDeleteLinesAction(IMenuManager manager, Collection<DLine> selectedLines) {
        this.deleteLinesAction.setLines(selectedLines);
        if (this.deleteLinesAction.canExecute()) {
            manager.add((IAction)this.deleteLinesAction);
        }
    }

    private void createDetailsActions(DTableElement currentElement, SubContributionItem newMenuItems) {
        RepresentationElementMapping mapping = currentElement.getMapping();
        if (mapping != null) {
            Session session;
            Session session2 = session = currentElement.getTarget() != null ? SessionManager.INSTANCE.getSession(currentElement.getTarget()) : null;
            if (session != null) {
                for (RepresentationCreationDescription desc : mapping.getDetailDescriptions()) {
                    boolean append = true;
                    if (!this.isFromActiveViewpoint(session, desc.getRepresentationDescription())) {
                        append = false;
                    }
                    String precondition = desc.getPrecondition();
                    if (append && !StringUtil.isEmpty((String)precondition)) {
                        append = false;
                        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(currentElement.getTarget());
                        try {
                            append = interpreter.evaluateBoolean(currentElement.getTarget(), precondition);
                        }
                        catch (EvaluationException evaluationException) {}
                    }
                    if (!append) continue;
                    newMenuItems.setVisible(true);
                    ((IMenuManager)newMenuItems.getInnerItem()).appendToGroup(NEW_REPRESENTATION_GROUP_SEPARATOR, (IAction)new CreateRepresentationFromRepresentationCreationDescription(desc, (DRepresentationElement)currentElement, this.treeViewManager.getEditingDomain(), this.treeViewManager.getTableCommandFactory()));
                }
            }
        }
    }

    private boolean isFromActiveViewpoint(Session session, RepresentationDescription representationDescription) {
        Viewpoint vp = ViewpointRegistry.getInstance().getViewpoint(representationDescription);
        return vp != null && session.getSelectedViewpoints(false).contains(vp);
    }

    protected Map<TableMapping, DeleteTargetColumnAction> getMappingToDeleteActions() {
        return this.mappingToDeleteColumnActions;
    }

    public void setMappingToDeleteActions(Map<TableMapping, DeleteTargetColumnAction> mappingToDeleteActions) {
        this.mappingToDeleteColumnActions = mappingToDeleteActions;
    }

    protected Map<TableMapping, List<AbstractToolAction>> getMappingToCreateActions() {
        return this.mappingToCreateActions;
    }

    public void setMappingToCreateActions(Map<TableMapping, List<AbstractToolAction>> mappingToCreateActions) {
        this.mappingToCreateActions = mappingToCreateActions;
    }

    protected List<AbstractToolAction> getCreateActionsForTable() {
        return this.createActionsForTable;
    }

    public void setCreateActionsForTable(List<AbstractToolAction> createActionsForTable) {
        this.createActionsForTable = createActionsForTable;
    }

    public void setTable(DTable newDRepresentation) {
        this.dTable = newDRepresentation;
    }
}

