/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.modelunfolding;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.BooleanElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.Element;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.IntegerElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.PrimitiveElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.RealElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.SequenceElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.StringElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.Block;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.ClassicalExpression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockConstraintSystem;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ConcreteEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ConditionalExpressionDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ConditionalRelationDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExprCase;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Expression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExpressionDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExpressionDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExternalExpressionDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExternalRelationDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.KernelExpressionDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.KernelRelationDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelCase;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Relation;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelationDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelationDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.UserExpressionDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.UserRelationDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.Clock;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.NamedElement;
import fr.inria.aoste.timesquare.ccslkernel.model.visitor.Visitor;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiatedElement;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiationPath;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.RecursiveDefinitionChecker;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.UnfoldModel;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.DefinitionNotFound;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.ExceptionWrapper;
import java.util.ArrayDeque;
import java.util.Deque;
import org.eclipse.emf.ecore.EObject;

public class ModelUnfoldingPassOne
extends Visitor<InstantiatedElement> {
    protected Deque<Block> blockStack;
    protected InstantiationPath instantiationPath;
    protected UnfoldModel unfoldModel;
    protected static final InstantiatedElement dummy = new InstantiatedElement(null, null);

    public ModelUnfoldingPassOne(UnfoldModel unfoldModel) {
        this.unfoldModel = unfoldModel;
        this.instantiationPath = new InstantiationPath();
        this.blockStack = new ArrayDeque<Block>();
    }

    private InstantiatedElement lookupInstance(InstantiationPath path) {
        InstantiatedElement existing = this.unfoldModel.getInstantiationTree().lookupInstance(path);
        return existing;
    }

    private InstantiatedElement initInstance(InstantiationPath path) {
        InstantiatedElement newElement = new InstantiatedElement(new InstantiationPath(path), null);
        this.unfoldModel.getInstantiationTree().storeInstance(path, newElement);
        return newElement;
    }

    private InstantiatedElement lookupOrCreateInstance(InstantiationPath path) {
        InstantiatedElement existing = this.lookupInstance(this.instantiationPath);
        if (existing == null) {
            return this.initInstance(this.instantiationPath);
        }
        return existing;
    }

    protected InstantiatedElement visitClockConstraintSystem(ClockConstraintSystem cs) {
        if (this.blockStack.contains(cs)) {
            return dummy;
        }
        this.blockStack.push((Block)cs);
        this.instantiationPath.push((NamedElement)cs);
        InstantiatedElement elt = (InstantiatedElement)this.visit((EObject)cs.getSuperBlock());
        this.instantiationPath.pop();
        this.blockStack.pop();
        return elt;
    }

    protected InstantiatedElement visitBlock(Block object) {
        if (this.blockStack.contains(object)) {
            return dummy;
        }
        this.blockStack.push(object);
        this.instantiationPath.push((NamedElement)object);
        for (Element elt : object.getElements()) {
            ((InstantiatedElement)this.visit((EObject)elt)).setTopLevel(true);
        }
        for (Expression ex : object.getExpressions()) {
            ((InstantiatedElement)this.visit((EObject)ex)).setTopLevel(true);
        }
        for (Relation rel : object.getRelations()) {
            ((InstantiatedElement)this.visit((EObject)rel)).setTopLevel(true);
        }
        for (Block sub : object.getSubBlock()) {
            this.visit((EObject)sub);
        }
        for (ClassicalExpression classicalExpr : object.getClassicalExpression()) {
            ((InstantiatedElement)this.visit((EObject)classicalExpr)).setTopLevel(true);
        }
        this.instantiationPath.pop();
        this.blockStack.pop();
        return dummy;
    }

    protected InstantiatedElement visitClock(Clock c) {
        this.instantiationPath.push((NamedElement)c);
        InstantiatedElement elt = this.lookupOrCreateInstance(this.instantiationPath);
        elt.setLeaf(true);
        if (c.eContainer() instanceof Block) {
            elt.setTopLevel(true);
        }
        this.instantiationPath.pop();
        return elt;
    }

    protected InstantiatedElement visitClassicalExpression(ClassicalExpression object) {
        this.instantiationPath.push((NamedElement)object);
        InstantiatedElement elt = this.lookupOrCreateInstance(this.instantiationPath);
        elt.setLeaf(true);
        if (object.eContainer() instanceof Block) {
            elt.setTopLevel(true);
        }
        this.instantiationPath.pop();
        return elt;
    }

    protected InstantiatedElement visitSequenceElement(SequenceElement seq) {
        this.instantiationPath.push((NamedElement)seq);
        InstantiatedElement elt = this.lookupOrCreateInstance(this.instantiationPath);
        elt.setLeaf(true);
        if (seq.eContainer() instanceof Block) {
            elt.setTopLevel(true);
        }
        elt.setValue((Element)seq);
        this.instantiationPath.pop();
        return elt;
    }

    protected InstantiatedElement visitElement(Element el) {
        this.instantiationPath.push((NamedElement)el);
        InstantiatedElement elt = this.lookupOrCreateInstance(this.instantiationPath);
        elt.setLeaf(true);
        if (el.eContainer() instanceof Block) {
            elt.setTopLevel(true);
        }
        this.instantiationPath.pop();
        return elt;
    }

    protected InstantiatedElement visitPrimitiveElement(PrimitiveElement el) {
        this.instantiationPath.push((NamedElement)el);
        InstantiatedElement elt = this.lookupOrCreateInstance(this.instantiationPath);
        elt.setLeaf(true);
        if (el.eContainer() instanceof Block) {
            elt.setTopLevel(true);
        }
        if (el instanceof IntegerElement || el instanceof RealElement || el instanceof BooleanElement || el instanceof StringElement) {
            elt.setConstant(true);
            elt.setValue((Element)el);
        }
        this.instantiationPath.pop();
        return elt;
    }

    protected InstantiatedElement visitExpression(Expression ex) {
        ExpressionDeclaration decl;
        this.instantiationPath.push((NamedElement)ex);
        InstantiatedElement newElement = this.lookupOrCreateInstance(this.instantiationPath);
        if (ex.eContainer() instanceof Block) {
            newElement.setTopLevel(true);
        }
        if ((decl = ex.getType()) instanceof KernelExpressionDeclaration) {
            newElement.setLeaf(true);
            newElement.setIsKernel(true);
        } else {
            newElement.setLeaf(false);
            newElement.setIsKernel(false);
            ExpressionDefinition def = this.unfoldModel.lookupExpressionDefinition(decl);
            if (def == null) {
                throw new ExceptionWrapper(new DefinitionNotFound("No definition found for expression declaration" + decl.getName()));
            }
            this.unfoldModel.recordExpressionDefinitionUse(decl, def);
            if (def instanceof ExternalExpressionDefinition) {
                newElement.setLeaf(true);
            } else {
                int defIndex = this.instantiationPath.lastIndexOf(def);
                RecursiveDefinitionChecker checker = new RecursiveDefinitionChecker(def);
                if (defIndex < 0 || defIndex != this.instantiationPath.size() - 2 || !checker.isTailRecursive()) {
                    this.visit((EObject)def);
                }
            }
        }
        this.unfoldModel.getInstantiationTree().storeInstance(this.instantiationPath, newElement);
        this.instantiationPath.pop();
        return newElement;
    }

    protected InstantiatedElement visitUserExpressionDefinition(UserExpressionDefinition def) {
        this.instantiationPath.push((NamedElement)def);
        for (ClassicalExpression expr : def.getClassicalExpressions()) {
            this.visit((EObject)expr);
        }
        for (ConcreteEntity concrete : def.getConcreteEntities()) {
            this.visit((EObject)concrete);
        }
        this.instantiationPath.removeLast((NamedElement)def);
        return dummy;
    }

    protected InstantiatedElement visitConditionalExpressionDefinition(ConditionalExpressionDefinition cd) {
        this.instantiationPath.push((NamedElement)cd);
        for (ClassicalExpression expr : cd.getClassicalExpressions()) {
            this.visit((EObject)expr);
        }
        for (ConcreteEntity concrete : cd.getConcreteEntities()) {
            this.visit((EObject)concrete);
        }
        for (ExprCase eCase : cd.getExprCases()) {
            this.visit((EObject)eCase);
        }
        if (cd.getDefaultExpression() != null) {
            this.visit((EObject)cd.getDefaultExpression());
        }
        this.instantiationPath.pop();
        return dummy;
    }

    protected InstantiatedElement visitExprCase(ExprCase object) {
        this.visit((EObject)object.getCondition());
        this.visit((EObject)object.getExpression());
        return dummy;
    }

    protected InstantiatedElement visitRelation(Relation object) {
        RelationDeclaration decl;
        this.instantiationPath.push((NamedElement)object);
        InstantiatedElement newElement = this.lookupOrCreateInstance(this.instantiationPath);
        if (object.eContainer() instanceof Block) {
            newElement.setTopLevel(true);
        }
        if ((decl = object.getType()) instanceof KernelRelationDeclaration) {
            newElement.setLeaf(true);
            newElement.setIsKernel(true);
        } else {
            newElement.setLeaf(false);
            newElement.setIsKernel(false);
            RelationDefinition def = this.unfoldModel.lookupRelationDefinition(decl);
            if (def == null) {
                throw new ExceptionWrapper(new DefinitionNotFound("No definition found for relation declaration" + decl.getName()));
            }
            this.unfoldModel.recordRelationDefinitionUse(decl, def);
            if (def instanceof ExternalRelationDefinition) {
                newElement.setLeaf(true);
            } else {
                this.visit((EObject)def);
            }
        }
        this.unfoldModel.getInstantiationTree().storeInstance(this.instantiationPath, newElement);
        this.instantiationPath.pop();
        return newElement;
    }

    protected InstantiatedElement visitUserRelationDefinition(UserRelationDefinition object) {
        this.instantiationPath.push((NamedElement)object);
        for (ClassicalExpression expr : object.getClassicalExpressions()) {
            this.visit((EObject)expr);
        }
        for (ConcreteEntity concrete : object.getConcreteEntities()) {
            this.visit((EObject)concrete);
        }
        this.instantiationPath.pop();
        return dummy;
    }

    protected InstantiatedElement visitConditionalRelationDefinition(ConditionalRelationDefinition object) {
        this.instantiationPath.push((NamedElement)object);
        for (ClassicalExpression expr : object.getClassicalExpressions()) {
            this.visit((EObject)expr);
        }
        for (ConcreteEntity concrete : object.getConcreteEntities()) {
            this.visit((EObject)concrete);
        }
        for (RelCase cas : object.getRelCases()) {
            this.visit((EObject)cas);
        }
        for (Relation rel : object.getDefaultRelation()) {
            this.visit((EObject)rel);
        }
        this.instantiationPath.pop();
        return dummy;
    }

    protected InstantiatedElement visitRelCase(RelCase object) {
        this.visit((EObject)object.getCondition());
        for (Relation rel : object.getRelation()) {
            this.visit((EObject)rel);
        }
        return dummy;
    }
}

