/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.jdt;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gemoc.commons.eclipse.core.resources.IProjectUtils;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JavaProject {
    public static final String CLASSPATH_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry kind=\"src\" path=\"src/main/java\"/>\n\t<classpathentry kind=\"src\" path=\"src/main/xdsml-java-gen\"/>\n\t<classpathentry kind=\"con\" path=\"org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.6\"/>\n\t<classpathentry kind=\"output\" path=\"bin\"/>\n</classpath>";

    public static void create(IProject project) throws CoreException, IOException {
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            JavaCore.create((IProject)project);
            IProjectUtils.addNature((IProject)project, (String)"org.eclipse.jdt.core.javanature");
            IProjectUtils.createFolder((IProject)project, (String)"src/main/java", (IProgressMonitor)new NullProgressMonitor());
            IProjectUtils.createFolder((IProject)project, (String)"src/main/xdsml-java-gen", (IProgressMonitor)new NullProgressMonitor());
            JavaProject.addJavaResources(project);
        }
    }

    private static void addJavaResources(IProject project) throws CoreException, IOException {
        IFile file = project.getFile((IPath)new Path(".classpath"));
        try (ByteArrayInputStream stream = null;){
            stream = new ByteArrayInputStream(CLASSPATH_TEMPLATE.getBytes());
            if (file.exists()) {
                file.setContents((InputStream)stream, true, true, null);
            } else {
                file.create((InputStream)stream, true, null);
            }
        }
    }

    public static void addSourceFolder(IProject project, String folder) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
        System.arraycopy(entries, 0, newEntries, 0, entries.length);
        IPath srcPath = javaProject.getPath().append(folder);
        IClasspathEntry srcEntry = JavaCore.newSourceEntry((IPath)srcPath, null);
        boolean entryfound = false;
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (cpe.equals(srcEntry)) {
                entryfound = true;
            }
            ++n2;
        }
        if (!entryfound) {
            newEntries[entries.length] = JavaCore.newSourceEntry((IPath)srcEntry.getPath());
            javaProject.setRawClasspath(newEntries, null);
        }
    }
}

