/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.builder;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipFile;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationDecorator;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IModule;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IMultiModuleEntry;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.aspectj.org.eclipse.jdt.internal.core.JavaProject;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.core.runtime.IPath;

public class ClasspathJrt
extends ClasspathLocation
implements IMultiModuleEntry {
    protected static HashMap<String, HashMap<String, SimpleSet>> PackageCache = new HashMap();
    protected static HashMap<String, Set<IModule>> ModulesCache = new HashMap();
    String externalAnnotationPath;
    protected ZipFile annotationZipFile;
    String zipFilename;
    AccessRuleSet accessRuleSet;
    static final Set<String> NO_LIMIT_MODULES = new HashSet<String>();

    protected ClasspathJrt() {
    }

    public ClasspathJrt(String zipFilename, AccessRuleSet accessRuleSet, IPath externalAnnotationPath) {
        this.zipFilename = zipFilename;
        this.accessRuleSet = accessRuleSet;
        if (externalAnnotationPath != null) {
            this.externalAnnotationPath = externalAnnotationPath.toString();
        }
        ClasspathJrt.loadModules(this);
    }

    static HashMap<String, SimpleSet> findPackagesInModules(final ClasspathJrt jrt) {
        String zipFileName = jrt.zipFilename;
        HashMap<String, SimpleSet> cache = PackageCache.get(jrt.getKey());
        if (cache != null) {
            return cache;
        }
        final HashMap<String, SimpleSet> packagesInModule = new HashMap<String, SimpleSet>();
        PackageCache.put(zipFileName, packagesInModule);
        try {
            final File imageFile = new File(zipFileName);
            JRTUtil.walkModuleImage(imageFile, new JRTUtil.JrtFileVisitor<Path>(){
                SimpleSet packageSet = null;

                @Override
                public FileVisitResult visitPackage(Path dir, Path mod, BasicFileAttributes attrs) throws IOException {
                    ClasspathJar.addToPackageSet(this.packageSet, dir.toString(), true);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, Path mod, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitModule(Path path, String name) throws IOException {
                    try {
                        jrt.acceptModule(JRTUtil.getClassfileContent(imageFile, "module-info.class", name));
                    }
                    catch (ClassFormatException e) {
                        e.printStackTrace();
                    }
                    this.packageSet = new SimpleSet(41);
                    this.packageSet.add("");
                    if (name.endsWith("/")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    packagesInModule.put(name, this.packageSet);
                    return FileVisitResult.CONTINUE;
                }
            }, JRTUtil.NOTIFY_PACKAGES | JRTUtil.NOTIFY_MODULES);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return packagesInModule;
    }

    public static void loadModules(final ClasspathJrt jrt) {
        Set<IModule> cache = ModulesCache.get(jrt.getKey());
        if (cache == null) {
            try {
                final File imageFile = new File(jrt.zipFilename);
                JRTUtil.walkModuleImage(imageFile, new JRTUtil.JrtFileVisitor<Path>(){
                    SimpleSet packageSet = null;

                    @Override
                    public FileVisitResult visitPackage(Path dir, Path mod, BasicFileAttributes attrs) throws IOException {
                        ClasspathJar.addToPackageSet(this.packageSet, dir.toString(), true);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, Path mod, BasicFileAttributes attrs) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitModule(Path path, String name) throws IOException {
                        try {
                            jrt.acceptModule(JRTUtil.getClassfileContent(imageFile, "module-info.class", name));
                        }
                        catch (ClassFormatException e) {
                            e.printStackTrace();
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                }, JRTUtil.NOTIFY_MODULES);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected String getKey() {
        return this.zipFilename;
    }

    void acceptModule(byte[] content) {
        if (content == null) {
            return;
        }
        ClassFileReader reader = null;
        try {
            reader = new ClassFileReader(content, "module-info.class".toCharArray());
        }
        catch (ClassFormatException e) {
            e.printStackTrace();
        }
        if (reader != null) {
            String key = this.getKey();
            IBinaryModule moduleDecl = reader.getModuleDeclaration();
            if (moduleDecl != null) {
                Set<IModule> cache = ModulesCache.get(key);
                if (cache == null) {
                    cache = new HashSet<IModule>();
                    ModulesCache.put(key, cache);
                }
                cache.add(moduleDecl);
            }
        }
    }

    @Override
    public void cleanup() {
        if (this.annotationZipFile != null) {
            try {
                this.annotationZipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.annotationZipFile = null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathJrt)) {
            return false;
        }
        ClasspathJrt jar = (ClasspathJrt)o;
        if (!(this.accessRuleSet == jar.accessRuleSet || this.accessRuleSet != null && this.accessRuleSet.equals(jar.accessRuleSet))) {
            return false;
        }
        return this.zipFilename.endsWith(jar.zipFilename) && this.areAllModuleOptionsEqual(jar);
    }

    @Override
    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        if (!this.isPackage(qualifiedPackageName, moduleName)) {
            return null;
        }
        try {
            String fileNameWithoutExtension = qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - SuffixConstants.SUFFIX_CLASS.length);
            ClassFileReader reader = ClassFileReader.readFromModule(new File(this.zipFilename), moduleName, qualifiedBinaryFileName, moduleNameFilter);
            return this.createAnswer(fileNameWithoutExtension, reader);
        }
        catch (IOException | ClassFormatException exception) {
            return null;
        }
    }

    protected NameEnvironmentAnswer createAnswer(String fileNameWithoutExtension, IBinaryType reader) {
        if (reader != null) {
            if (this.externalAnnotationPath != null) {
                try {
                    if (this.annotationZipFile == null) {
                        this.annotationZipFile = ExternalAnnotationDecorator.getAnnotationZipFile(this.externalAnnotationPath, null);
                    }
                    reader = ExternalAnnotationDecorator.create(reader, this.externalAnnotationPath, fileNameWithoutExtension, this.annotationZipFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.accessRuleSet == null) {
                return new NameEnvironmentAnswer(reader, null, reader.getModule());
            }
            return new NameEnvironmentAnswer(reader, this.accessRuleSet.getViolatedRestriction(fileNameWithoutExtension.toCharArray()), reader.getModule());
        }
        return null;
    }

    @Override
    public IPath getProjectRelativePath() {
        return null;
    }

    public int hashCode() {
        return this.zipFilename == null ? super.hashCode() : this.zipFilename.hashCode();
    }

    @Override
    public char[][] getModulesDeclaringPackage(String qualifiedPackageName, String moduleName) {
        List<String> moduleNames = JRTUtil.getModulesDeclaringPackage(new File(this.zipFilename), qualifiedPackageName, moduleName);
        return CharOperation.toCharArrays(moduleNames);
    }

    @Override
    public boolean hasCompilationUnit(String qualifiedPackageName, String moduleName) {
        return JRTUtil.hasCompilationUnit(new File(this.zipFilename), qualifiedPackageName, moduleName);
    }

    @Override
    public boolean isPackage(String qualifiedPackageName, String moduleName) {
        return JRTUtil.getModulesDeclaringPackage(new File(this.zipFilename), qualifiedPackageName, moduleName) != null;
    }

    public String toString() {
        String start = "Classpath jrt file " + this.zipFilename;
        return start;
    }

    @Override
    public String debugPathString() {
        return this.zipFilename;
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        String fileName = new String(typeName);
        return this.findClass(fileName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, asBinaryOnly, moduleNameFilter);
    }

    @Override
    public boolean hasModule() {
        return true;
    }

    @Override
    public IModule getModule(char[] moduleName) {
        Set<IModule> modules = ModulesCache.get(this.getKey());
        if (modules != null) {
            for (IModule mod : modules) {
                if (!CharOperation.equals(mod.name(), moduleName)) continue;
                return mod;
            }
        }
        return null;
    }

    @Override
    public Collection<String> getModuleNames(Collection<String> limitModules) {
        HashMap<String, SimpleSet> cache = ClasspathJrt.findPackagesInModules(this);
        if (cache != null) {
            return this.selectModules(cache.keySet(), limitModules);
        }
        return Collections.emptyList();
    }

    protected Collection<String> selectModules(Set<String> keySet, Collection<String> limitModules) {
        Collection<String> rootModules;
        if (limitModules == NO_LIMIT_MODULES) {
            rootModules = new HashSet<String>(keySet);
        } else if (limitModules != null) {
            HashSet<String> result = new HashSet<String>(keySet);
            result.retainAll(limitModules);
            rootModules = result;
        } else {
            rootModules = JavaProject.internalDefaultRootModules(keySet, s -> s, m -> this.getModule(m.toCharArray()));
        }
        HashSet<String> allModules = new HashSet<String>(rootModules);
        for (String mod : rootModules) {
            this.addRequired(mod, allModules);
        }
        return allModules;
    }

    protected void addRequired(String mod, Set<String> allModules) {
        IModule iMod = this.getModule(mod.toCharArray());
        if (iMod == null) {
            return;
        }
        IModule.IModuleReference[] iModuleReferenceArray = iMod.requires();
        int n = iModuleReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            String reqModName;
            IModule.IModuleReference requiredRef = iModuleReferenceArray[n2];
            IModule reqMod = this.getModule(requiredRef.name());
            if (reqMod != null && allModules.add(reqModName = String.valueOf(reqMod.name()))) {
                this.addRequired(reqModName, allModules);
            }
            ++n2;
        }
    }

    @Override
    public NameEnvironmentAnswer findClass(String typeName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName) {
        return this.findClass(typeName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, false, null);
    }

    public static void resetCaches() {
        PackageCache.clear();
        ModulesCache.clear();
    }
}

