/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompactConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Parser;

public class RecordDeclaration
extends TypeDeclaration {
    private Argument[] args;
    public int nRecordComponents;
    public boolean isLocalRecord;
    public static Set<String> disallowedComponentNames = new HashSet<String>(6);

    static {
        disallowedComponentNames.add("clone");
        disallowedComponentNames.add("finalize");
        disallowedComponentNames.add("getClass");
        disallowedComponentNames.add("hashCode");
        disallowedComponentNames.add("notify");
        disallowedComponentNames.add("notifyAll");
        disallowedComponentNames.add("toString");
        disallowedComponentNames.add("wait");
    }

    public RecordDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
        this.modifiers |= 0x1000000;
    }

    public RecordDeclaration(TypeDeclaration t) {
        super(t.compilationResult);
        this.modifiers = t.modifiers | 0x1000000;
        this.modifiersSourceStart = t.modifiersSourceStart;
        this.annotations = t.annotations;
        this.name = t.name;
        this.superInterfaces = t.superInterfaces;
        this.fields = t.fields;
        this.methods = t.methods;
        this.memberTypes = t.memberTypes;
        this.binding = t.binding;
        this.scope = t.scope;
        this.initializerScope = t.initializerScope;
        this.staticInitializerScope = t.staticInitializerScope;
        this.ignoreFurtherInvestigation = t.ignoreFurtherInvestigation;
        this.maxFieldCount = t.maxFieldCount;
        this.declarationSourceStart = t.declarationSourceStart;
        this.declarationSourceEnd = t.declarationSourceEnd;
        this.bodyStart = t.bodyStart;
        this.bodyEnd = t.bodyEnd;
        this.missingAbstractMethods = t.missingAbstractMethods;
        this.javadoc = t.javadoc;
        this.allocation = t.allocation;
        this.enclosingType = t.enclosingType;
        this.typeParameters = t.typeParameters;
        this.sourceStart = t.sourceStart;
        this.sourceEnd = t.sourceEnd;
        this.restrictedIdentifierStart = t.restrictedIdentifierStart;
    }

    public ConstructorDeclaration getConstructor(Parser parser) {
        if (this.methods != null) {
            int i = this.methods.length;
            while (--i >= 0) {
                AbstractMethodDeclaration am = this.methods[i];
                if (!am.isConstructor()) continue;
                if (!CharOperation.equals(am.selector, this.name)) {
                    ConstructorDeclaration c = (ConstructorDeclaration)am;
                    if (c.constructorCall != null && !c.constructorCall.isImplicitSuper()) continue;
                    MethodDeclaration m = parser.convertToMethodDeclaration(c, this.compilationResult);
                    this.methods[i] = m;
                    continue;
                }
                if (am instanceof CompactConstructorDeclaration) {
                    CompactConstructorDeclaration ccd = (CompactConstructorDeclaration)am;
                    ccd.recordDeclaration = this;
                    if (ccd.arguments == null) {
                        ccd.arguments = this.args;
                    }
                    return ccd;
                }
                if (this.args != null || am.arguments != null) continue;
                return (ConstructorDeclaration)am;
            }
        }
        return null;
    }

    public static ConstructorDeclaration getImplicitCanonicalConstructor(AbstractMethodDeclaration[] methods) {
        if (methods == null) {
            return null;
        }
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractMethodDeclaration am = abstractMethodDeclarationArray[n2];
            if (am instanceof ConstructorDeclaration && (am.bits & 0x600) != 0) {
                return (ConstructorDeclaration)am;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public ConstructorDeclaration createDefaultConstructor(boolean needExplicitConstructorCall, boolean needToInsert) {
        int l;
        ConstructorDeclaration constructor = new ConstructorDeclaration(this.compilationResult);
        constructor.bits |= 0x600;
        constructor.selector = this.name;
        constructor.modifiers = this.modifiers & 1;
        constructor.modifiers |= 1;
        constructor.arguments = this.args;
        constructor.sourceStart = constructor.bodyStart = this.sourceStart;
        constructor.declarationSourceStart = constructor.bodyStart;
        constructor.sourceEnd = constructor.bodyEnd = this.sourceStart - 1;
        constructor.declarationSourceEnd = constructor.bodyEnd;
        if (needExplicitConstructorCall) {
            constructor.constructorCall = SuperReference.implicitSuperConstructorCall();
            constructor.constructorCall.sourceStart = this.sourceStart;
            constructor.constructorCall.sourceEnd = this.sourceEnd;
        }
        ArrayList<Assignment> statements = new ArrayList<Assignment>();
        int n = l = this.args != null ? this.args.length : 0;
        if (l > 0 && this.fields != null) {
            List fNames = Arrays.stream(this.fields).filter(f -> f.isARecordComponent).map(f -> new String(f.name)).collect(Collectors.toList());
            int i = 0;
            while (i < l) {
                Argument arg = this.args[i];
                if (fNames.contains(new String(arg.name))) {
                    FieldReference lhs = new FieldReference(arg.name, 0L);
                    lhs.receiver = ThisReference.implicitThis();
                    statements.add(new Assignment(lhs, new SingleNameReference(arg.name, 0L), 0));
                }
                ++i;
            }
        }
        constructor.statements = statements.toArray(new Statement[0]);
        if (needToInsert) {
            if (this.methods == null) {
                this.methods = new AbstractMethodDeclaration[]{constructor};
            } else {
                AbstractMethodDeclaration[] newMethods = new AbstractMethodDeclaration[this.methods.length + 1];
                System.arraycopy(this.methods, 0, newMethods, 1, this.methods.length);
                newMethods[0] = constructor;
                this.methods = newMethods;
            }
        }
        return constructor;
    }

    @Override
    public void generateCode(ClassFile enclosingClassFile) {
        super.generateCode(enclosingClassFile);
    }

    @Override
    public boolean isRecord() {
        return true;
    }

    @Override
    public StringBuffer printHeader(int indent, StringBuffer output) {
        int i;
        RecordDeclaration.printModifiers(this.modifiers, output);
        if (this.annotations != null) {
            RecordDeclaration.printAnnotations(this.annotations, output);
            output.append(' ');
        }
        output.append("record ");
        output.append(this.name);
        output.append('(');
        if (this.nRecordComponents > 0 && this.fields != null) {
            i = 0;
            while (i < this.nRecordComponents) {
                if (i > 0) {
                    output.append(", ");
                }
                output.append(this.fields[i].type.getTypeName()[0]);
                output.append(' ');
                output.append(this.fields[i].name);
                ++i;
            }
        }
        output.append(')');
        if (this.typeParameters != null) {
            output.append("<");
            i = 0;
            while (i < this.typeParameters.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.typeParameters[i].print(0, output);
                ++i;
            }
            output.append(">");
        }
        if (this.superInterfaces != null && this.superInterfaces.length > 0) {
            output.append(" implements ");
            i = 0;
            while (i < this.superInterfaces.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.superInterfaces[i].print(0, output);
                ++i;
            }
        }
        return output;
    }

    @Override
    public StringBuffer printBody(int indent, StringBuffer output) {
        int i;
        output.append(" {");
        if (this.memberTypes != null) {
            i = 0;
            while (i < this.memberTypes.length) {
                if (this.memberTypes[i] != null) {
                    output.append('\n');
                    this.memberTypes[i].print(indent + 1, output);
                }
                ++i;
            }
        }
        if (this.fields != null) {
            int fieldI = 0;
            while (fieldI < this.fields.length) {
                if (this.fields[fieldI] != null) {
                    output.append('\n');
                    if (fieldI < this.nRecordComponents) {
                        output.append("/* Implicit */");
                    }
                    this.fields[fieldI].print(indent + 1, output);
                }
                ++fieldI;
            }
        }
        if (this.methods != null) {
            i = 0;
            while (i < this.methods.length) {
                if (this.methods[i] != null) {
                    output.append('\n');
                    AbstractMethodDeclaration amd = this.methods[i];
                    if (amd instanceof MethodDeclaration && (amd.bits & 0x400) != 0) {
                        output.append("/* Implicit */\n");
                    }
                    amd.print(indent + 1, output);
                }
                ++i;
            }
        }
        output.append('\n');
        return RecordDeclaration.printIndent(indent, output).append('}');
    }

    public Argument[] getArgs() {
        return this.args;
    }

    public void setArgs(Argument[] args) {
        this.args = args;
    }

    public static void checkAndFlagRecordNameErrors(char[] typeName, ASTNode node, Scope skope) {
        if (CharOperation.equals(typeName, TypeConstants.RECORD_RESTRICTED_IDENTIFIER) && skope.compilerOptions().sourceLevel == 0x3A0000L) {
            skope.problemReporter().recordIsAReservedTypeName(node);
        }
    }

    AbstractMethodDeclaration[] getMethod(char[] name1) {
        if (name1 == null || name1.length == 0 || this.methods == null) {
            return null;
        }
        ArrayList<AbstractMethodDeclaration> amList = new ArrayList<AbstractMethodDeclaration>(0);
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = this.methods;
        int n = this.methods.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractMethodDeclaration amd = abstractMethodDeclarationArray[n2];
            if (CharOperation.equals(name1, amd.selector)) {
                amList.add(amd);
            }
            ++n2;
        }
        return amList.toArray(new AbstractMethodDeclaration[0]);
    }
}

