/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.validation;

import java.util.LinkedList;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.validation.type.AbstractCollectionType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;

public final class QualifiedNames {
    private QualifiedNames() {
    }

    public static String getQualifiedName(EClassifier cls) {
        if (cls.getEPackage() == null) {
            boolean classNameIsKnown = cls.getInstanceClassName() != null && !cls.getInstanceClassName().isEmpty();
            return classNameIsKnown ? cls.getInstanceClassName() : cls.getName();
        }
        return String.valueOf(QualifiedNames.getQualifiedName(cls.getEPackage())) + "::" + cls.getName();
    }

    public static String getQualifiedName(EPackage pkg) {
        LinkedList<EPackage> pkgs = new LinkedList<EPackage>();
        EPackage current = pkg;
        while (current != null) {
            pkgs.addFirst(current);
            current = current.getESuperPackage();
        }
        return pkgs.stream().map(p -> p.getName()).collect(Collectors.joining("::"));
    }

    public static String getQualifiedName(IType type) {
        if (type instanceof SetType) {
            AbstractCollectionType collectionType = (AbstractCollectionType)type;
            return "Set(" + QualifiedNames.getQualifiedName(collectionType.getCollectionType()) + ")";
        }
        if (type instanceof SequenceType) {
            AbstractCollectionType collectionType = (AbstractCollectionType)type;
            return "Sequence(" + QualifiedNames.getQualifiedName(collectionType.getCollectionType()) + ")";
        }
        if (type instanceof AbstractCollectionType) {
            AbstractCollectionType collectionType = (AbstractCollectionType)type;
            return "Collection(" + QualifiedNames.getQualifiedName(collectionType.getCollectionType()) + ")";
        }
        if (type instanceof EClassifierType) {
            EClassifier cls = ((EClassifierType)type).getType();
            return QualifiedNames.getQualifiedName(cls);
        }
        return String.valueOf(type);
    }
}

