/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.classpath.ClasspathEntry;
import org.eclipse.osgi.internal.loader.classpath.ClasspathManager;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

public abstract class ModuleClassLoader
extends ClassLoader
implements BundleReference {
    protected static final PermissionCollection ALLPERMISSIONS;
    protected static final boolean REGISTERED_AS_PARALLEL;
    private final Map<String, Thread> classNameLocks = new HashMap<String, Thread>(5);
    private final Object pkgLock = new Object();

    static {
        boolean registered;
        try {
            registered = ClassLoader.registerAsParallelCapable();
        }
        catch (Throwable throwable) {
            registered = false;
        }
        REGISTERED_AS_PARALLEL = registered;
        AllPermission allPerm = new AllPermission();
        ALLPERMISSIONS = allPerm.newPermissionCollection();
        if (ALLPERMISSIONS != null) {
            ALLPERMISSIONS.add(allPerm);
        }
    }

    public ModuleClassLoader(ClassLoader parent) {
        super(parent);
    }

    protected abstract BundleInfo.Generation getGeneration();

    protected abstract Debug getDebug();

    public abstract ClasspathManager getClasspathManager();

    protected abstract EquinoxConfiguration getConfiguration();

    public abstract BundleLoader getBundleLoader();

    public abstract boolean isRegisteredAsParallel();

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.getBundleLoader().findClass(name);
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    protected Class<?> findClass(String moduleName, String name) {
        try {
            return this.findLocalClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.findLocalClass(name);
    }

    @Override
    public URL getResource(String name) {
        URL url;
        if (this.getDebug().DEBUG_LOADER) {
            Debug.println("ModuleClassLoader[" + this.getBundleLoader() + "].getResource(" + name + ")");
        }
        if ((url = this.getBundleLoader().findResource(name)) != null) {
            return url;
        }
        if (this.getDebug().DEBUG_LOADER) {
            Debug.println("ModuleClassLoader[" + this.getBundleLoader() + "].getResource(" + name + ") failed.");
        }
        return null;
    }

    @Override
    protected URL findResource(String moduleName, String name) {
        return this.findLocalResource(name);
    }

    @Override
    protected URL findResource(String name) {
        return this.findLocalResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.getDebug().DEBUG_LOADER) {
            Debug.println("ModuleClassLoader[" + this.getBundleLoader() + "].getResources(" + name + ")");
        }
        Enumeration<URL> result = this.getBundleLoader().findResources(name);
        if (this.getDebug().DEBUG_LOADER && (result == null || !result.hasMoreElements())) {
            Debug.println("ModuleClassLoader[" + this.getBundleLoader() + "].getResources(" + name + ") failed.");
        }
        return result;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.findLocalResources(name);
    }

    @Override
    protected String findLibrary(String libname) {
        return this.getClasspathManager().findLibrary(libname);
    }

    public ClasspathEntry createClassPathEntry(BundleFile bundlefile, BundleInfo.Generation entryGeneration) {
        return new ClasspathEntry(bundlefile, this.createProtectionDomain(bundlefile, entryGeneration), entryGeneration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DefineClassResult defineClass(String name, byte[] classbytes, ClasspathEntry classpathEntry) {
        boolean defined = false;
        Class<?> result = null;
        if (this.isRegisteredAsParallel()) {
            boolean initialLock = this.lockClassName(name);
            try {
                result = this.findLoadedClass(name);
                if (result != null) return new DefineClassResult(result, defined);
                result = this.defineClass(name, classbytes, 0, classbytes.length, classpathEntry.getDomain());
                defined = true;
                return new DefineClassResult(result, defined);
            }
            finally {
                if (initialLock) {
                    this.unlockClassName(name);
                }
            }
        }
        ModuleClassLoader moduleClassLoader = this;
        synchronized (moduleClassLoader) {
            result = this.findLoadedClass(name);
            if (result != null) return new DefineClassResult(result, defined);
            result = this.defineClass(name, classbytes, 0, classbytes.length, classpathEntry.getDomain());
            defined = true;
            return new DefineClassResult(result, defined);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> publicFindLoaded(String classname) {
        if (this.isRegisteredAsParallel()) {
            return this.findLoadedClass(classname);
        }
        ModuleClassLoader moduleClassLoader = this;
        synchronized (moduleClassLoader) {
            return this.findLoadedClass(classname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Package publicGetPackage(String pkgname) {
        Object object = this.pkgLock;
        synchronized (object) {
            return this.getPackage(pkgname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Package publicDefinePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) {
        Object object = this.pkgLock;
        synchronized (object) {
            Package pkg = this.getPackage(name);
            return pkg != null ? pkg : this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
        }
    }

    public URL findLocalResource(String resource) {
        return this.getClasspathManager().findLocalResource(resource);
    }

    public Enumeration<URL> findLocalResources(String resource) {
        return this.getClasspathManager().findLocalResources(resource);
    }

    public Class<?> findLocalClass(String classname) throws ClassNotFoundException {
        return this.getClasspathManager().findLocalClass(classname);
    }

    protected ProtectionDomain createProtectionDomain(BundleFile bundlefile, BundleInfo.Generation domainGeneration) {
        ProtectionDomain baseDomain = domainGeneration.getDomain();
        try {
            File file;
            PermissionCollection permissions = baseDomain != null ? baseDomain.getPermissions() : ALLPERMISSIONS;
            Certificate[] certs = null;
            if (this.getConfiguration().CLASS_CERTIFICATE) {
                SignerInfo[] signers;
                SignedContent signedContent;
                Bundle b = this.getBundle();
                SignedContent signedContent2 = signedContent = b == null ? null : b.adapt(SignedContent.class);
                if (signedContent != null && signedContent.isSigned() && (signers = signedContent.getSignerInfos()).length > 0) {
                    certs = signers[0].getCertificateChain();
                }
            }
            return new GenerationProtectionDomain((file = bundlefile.getBaseFile()) == null ? null : new CodeSource(file.toURL(), certs), permissions, this.getGeneration());
        }
        catch (MalformedURLException malformedURLException) {
            return baseDomain;
        }
    }

    @Override
    public Bundle getBundle() {
        return this.getGeneration().getRevision().getBundle();
    }

    public List<URL> findEntries(String path, String filePattern, int options) {
        return this.getClasspathManager().findEntries(path, filePattern, options);
    }

    public Collection<String> listResources(String path, String filePattern, int options) {
        return this.getBundleLoader().listResources(path, filePattern, options);
    }

    public Collection<String> listLocalResources(String path, String filePattern, int options) {
        return this.getClasspathManager().listLocalResources(path, filePattern, options);
    }

    public String toString() {
        Bundle b = this.getBundle();
        StringBuilder result = new StringBuilder(super.toString());
        if (b == null) {
            return result.toString();
        }
        return result.append('[').append(b.getSymbolicName()).append(':').append(b.getVersion()).append("(id=").append(b.getBundleId()).append(")]").toString();
    }

    public void loadFragments(Collection<ModuleRevision> fragments) {
        this.getClasspathManager().loadFragments(fragments);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean lockClassName(String classname) {
        Map<String, Thread> map = this.classNameLocks;
        synchronized (map) {
            Thread lockingThread = this.classNameLocks.get(classname);
            Thread current = Thread.currentThread();
            if (lockingThread == current) {
                return false;
            }
            boolean previousInterruption = Thread.interrupted();
            try {
                while (true) {
                    if (lockingThread == null) {
                        this.classNameLocks.put(classname, current);
                        return true;
                    }
                    this.classNameLocks.wait();
                    lockingThread = this.classNameLocks.get(classname);
                    continue;
                    break;
                }
            }
            catch (InterruptedException e) {
                previousInterruption = true;
                throw new Error("Interrupted while waiting for classname lock: " + classname, e);
            }
            finally {
                if (previousInterruption) {
                    current.interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockClassName(String classname) {
        Map<String, Thread> map = this.classNameLocks;
        synchronized (map) {
            this.classNameLocks.remove(classname);
            this.classNameLocks.notifyAll();
        }
    }

    public void close() {
        this.getClasspathManager().close();
    }

    public static class DefineClassResult {
        public final Class<?> clazz;
        public final boolean defined;

        public DefineClassResult(Class<?> clazz, boolean defined) {
            this.clazz = clazz;
            this.defined = defined;
        }
    }

    public static class GenerationProtectionDomain
    extends ProtectionDomain
    implements BundleReference {
        private final BundleInfo.Generation generation;

        public GenerationProtectionDomain(CodeSource codesource, PermissionCollection permissions, BundleInfo.Generation generation) {
            super(codesource, permissions);
            this.generation = generation;
        }

        @Override
        public Bundle getBundle() {
            return this.generation.getRevision().getBundle();
        }
    }
}

