/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.builder;

import com.google.inject.Inject;
import fr.inria.diverse.melange.builder.LanguageOperatorBuilder;
import fr.inria.diverse.melange.builder.ModelTypingSpaceBuilder;
import fr.inria.diverse.melange.builder.RenamerHelper;
import fr.inria.diverse.melange.metamodel.melange.Merge;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Builder for the {@link Merge} operator.
 */
@SuppressWarnings("all")
public class MergeBuilder extends LanguageOperatorBuilder<Merge> {
  @Inject
  @Extension
  private RenamerHelper _renamerHelper;
  
  public MergeBuilder(final Merge op, final ModelTypingSpaceBuilder root) {
    super(op, root);
  }
  
  /**
   * Copy the set of {@link EPackage} built from the {@link Language} pointed by
   * the current {@link Merge} operator and apply the associated renaming rules.
   */
  @Override
  public void make() {
    boolean _isEmpty = this.targetModel.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      this.model = IterableExtensions.<EPackage>toSet(EcoreUtil.<EPackage>copyAll(this.targetModel));
      final Consumer<EPackage> _function = new Consumer<EPackage>() {
        @Override
        public void accept(final EPackage it) {
          MergeBuilder.this._renamerHelper.applyRenaming(it, MergeBuilder.this.source.getMappingRules());
        }
      };
      this.model.forEach(_function);
    }
  }
}
