/**
 * ---------------------------------------------------------------------------------------------
 * Copyright (c) 2020 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * --------------------------------------------------------------------------------------------
 */
package org.eclipse.gemoc.protocols.eaop.api.data;

import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

/**
 * Arguments for 'getState' request.
 */
@SuppressWarnings("all")
public class GetStateArguments {
  /**
   * ID or URI of the State
   */
  private String stateId;
  
  /**
   * ID or URI of the State
   */
  @Pure
  public String getStateId() {
    return this.stateId;
  }
  
  /**
   * ID or URI of the State
   */
  public void setStateId(final String stateId) {
    this.stateId = stateId;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("stateId", this.stateId);
    return b.toString();
  }
  
  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    GetStateArguments other = (GetStateArguments) obj;
    if (this.stateId == null) {
      if (other.stateId != null)
        return false;
    } else if (!this.stateId.equals(other.stateId))
      return false;
    return true;
  }
  
  @Override
  @Pure
  public int hashCode() {
    return 31 * 1 + ((this.stateId== null) ? 0 : this.stateId.hashCode());
  }
}
