/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.view;

import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorManagerGUI;
import fr.inria.aoste.timesquare.backend.manager.visible.IBehaviorManagerDialog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class BehaviorManagerDialog
extends Dialog
implements IBehaviorManagerDialog {
    private BehaviorManagerGUI _behaviorManagerGUI;
    private MessageLabeling label = null;
    private IStatus status = null;

    public static BehaviorManagerDialog create(BehaviorManagerGUI behaviorManagerGUI) {
        BehaviorManagerDialog behaviorManagerDialog = new BehaviorManagerDialog(new Shell());
        behaviorManagerDialog.setBehaviorManagerGUI(behaviorManagerGUI);
        behaviorManagerDialog.setBlockOnOpen(false);
        behaviorManagerDialog.open();
        return behaviorManagerDialog;
    }

    public BehaviorManagerDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(0x10 | this.getParentShell().getStyle());
        this._behaviorManagerGUI = null;
    }

    @Override
    public BehaviorManagerGUI getBehaviorManagerGUI() {
        return this._behaviorManagerGUI;
    }

    public void setBehaviorManagerGUI(BehaviorManagerGUI behaviorManagerGUI) {
        this._behaviorManagerGUI = behaviorManagerGUI;
        this._behaviorManagerGUI.setDialog(this);
    }

    public void cancelPressed() {
        if (this._behaviorManagerGUI != null) {
            this._behaviorManagerGUI.cancelPressed();
        }
        super.cancelPressed();
    }

    public void okPressed() {
        try {
            if (this._behaviorManagerGUI != null) {
                this._behaviorManagerGUI.okPressed();
            }
            super.okPressed();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        if (this._behaviorManagerGUI != null) {
            this.getShell().setText(this._behaviorManagerGUI.getPluginName());
            Control control = this._behaviorManagerGUI.createDialogArea(composite2);
            this.label = new MessageLabeling(composite2, 0);
            this.label.setAlignment(16384);
            GridData statusData = new GridData(768);
            this.label.setErrorStatus(null);
            this.label.setLayoutData(statusData);
            Point pt = this._behaviorManagerGUI.getMinimumSize();
            if (pt != null) {
                this.getShell().setMinimumSize(pt);
            }
            return control;
        }
        return null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        try {
            if (this._behaviorManagerGUI != null) {
                this._behaviorManagerGUI.updateOKStatus();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateStatus(IStatus updateStatus) {
        this.status = updateStatus;
        Button okButton = this.getOkButton();
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(!this.status.matches(4));
        }
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setErrorStatus(this.status);
        }
    }

    public Button getOkButton() {
        return this.getButton(0);
    }

    @Override
    public String getPluginName() {
        return this.getBehaviorManagerGUI().getPluginName();
    }

    public static class MessageLabeling
    extends CLabel {
        public MessageLabeling(Composite parent, int style) {
            super(parent, style);
        }

        private Image findImage(IStatus status) {
            if (status.isOK()) {
                return null;
            }
            if (status.matches(4)) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
            if (status.matches(2)) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }
            if (status.matches(1)) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
            }
            return null;
        }

        public void setErrorStatus(IStatus status) {
            String message;
            if (status != null && (message = status.getMessage()) != null && message.length() > 0) {
                this.setText(message);
                this.setImage(this.findImage(status));
                this.setBackground(JFaceColors.getErrorBackground((Display)this.getDisplay()));
                return;
            }
            this.setText("");
            this.setImage(null);
            this.setBackground(null);
        }
    }
}

