/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.Collections;
import java.util.HashMap;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.preserveorder.ModelOrderNodeComparator;
import org.eclipse.elk.alg.layered.intermediate.preserveorder.ModelOrderPortComparator;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.OrderingStrategy;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class SortByInputModelProcessor
implements ILayoutProcessor<LGraph> {
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        int layerIndex = 0;
        for (Layer layer : graph) {
            int previousLayerIndex = layerIndex == 0 ? 0 : layerIndex - 1;
            Layer previousLayer = graph.getLayers().get(previousLayerIndex);
            for (LNode node : layer.getNodes()) {
                if (node.getProperty(LayeredOptions.PORT_CONSTRAINTS) == PortConstraints.FIXED_ORDER && node.getProperty(LayeredOptions.PORT_CONSTRAINTS) == PortConstraints.FIXED_POS) continue;
                HashMap<LNode, Integer> targetNodeModelOrder = new HashMap<LNode, Integer>();
                node.getPorts().stream().filter(p -> !p.getOutgoingEdges().isEmpty()).forEach(p -> {
                    LNode targetNode = SortByInputModelProcessor.getTargetNode(p);
                    p.setProperty(InternalProperties.LONG_EDGE_TARGET_NODE, (Object)targetNode);
                    if (targetNode != null) {
                        int previousOrder = Integer.MAX_VALUE;
                        if (targetNodeModelOrder.containsKey((Object)targetNode)) {
                            previousOrder = (Integer)targetNodeModelOrder.get((Object)targetNode);
                        }
                        targetNodeModelOrder.put(targetNode, Math.min((Integer)p.getOutgoingEdges().get(0).getProperty(InternalProperties.MODEL_ORDER), previousOrder));
                    }
                });
                Collections.sort(node.getPorts(), new ModelOrderPortComparator(previousLayer, targetNodeModelOrder));
                node.cachePortSides();
            }
            Collections.sort(layer.getNodes(), new ModelOrderNodeComparator(previousLayer, (OrderingStrategy)((Object)graph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER))));
            ++layerIndex;
        }
    }

    public static LNode getTargetNode(LPort port) {
        LNode node = null;
        LEdge edge = port.getOutgoingEdges().get(0);
        do {
            if ((node = edge.getTarget().getNode()).hasProperty(InternalProperties.LONG_EDGE_TARGET)) {
                return ((LPort)((Object)node.getProperty(InternalProperties.LONG_EDGE_TARGET))).getNode();
            }
            if (node.getType() != LNode.NodeType.NORMAL && node.getOutgoingEdges().iterator().hasNext()) {
                edge = node.getOutgoingEdges().iterator().next();
                continue;
            }
            if (node.getType() == LNode.NodeType.NORMAL) continue;
            return null;
        } while (node != null && node.getType() != LNode.NodeType.NORMAL);
        return node;
    }
}

