/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Reference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class InstanceOfExpression
extends OperatorExpression {
    public Expression expression;
    public TypeReference type;
    public LocalDeclaration elementVariable;
    boolean isInitialized;

    public InstanceOfExpression(Expression expression, TypeReference type) {
        this.expression = expression;
        this.type = type;
        type.bits |= 0x40000000;
        this.bits |= 0x7C0;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = type.sourceEnd;
    }

    public InstanceOfExpression(Expression expression, LocalDeclaration local) {
        this.expression = expression;
        this.elementVariable = local;
        this.type = this.elementVariable.type;
        this.bits |= 0x7C0;
        this.elementVariable.sourceStart = local.sourceStart;
        this.elementVariable.sourceEnd = local.sourceEnd;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = local.declarationSourceEnd;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FieldBinding field;
        LocalVariableBinding local = this.expression.localVariableBinding();
        FlowInfo initsWhenTrue = null;
        if (local != null && (local.type.tagBits & 2L) == 0L) {
            flowInfo = this.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
            initsWhenTrue = flowInfo.copy();
            initsWhenTrue.markAsComparedEqualToNonNull(local);
            flowContext.recordUsingNullReference(currentScope, local, this.expression, 1025, flowInfo);
            flowInfo = FlowInfo.conditional(initsWhenTrue, flowInfo.copy());
        } else if (this.expression instanceof Reference && currentScope.compilerOptions().enableSyntacticNullAnalysisForFields && (field = ((Reference)this.expression).lastFieldBinding()) != null && (field.type.tagBits & 2L) == 0L) {
            flowContext.recordNullCheckedFieldReference((Reference)this.expression, 1);
        }
        if (initsWhenTrue == null) {
            flowInfo = this.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
            if (this.elementVariable != null) {
                initsWhenTrue = flowInfo.copy();
            }
        }
        if (this.elementVariable != null) {
            if (this.elementVariable.duplicateCheckObligation != null) {
                this.elementVariable.duplicateCheckObligation.accept(flowInfo);
            }
            initsWhenTrue.markAsDefinitelyAssigned(this.elementVariable.binding);
        }
        return initsWhenTrue == null ? flowInfo : FlowInfo.conditional(initsWhenTrue, flowInfo.copy());
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        this.initializePatternVariables(currentScope, codeStream);
        int pc = codeStream.position;
        this.expression.generateCode(currentScope, codeStream, true);
        codeStream.instance_of(this.type, this.type.resolvedType);
        if (this.elementVariable != null) {
            BranchLabel actionLabel = new BranchLabel(codeStream);
            codeStream.dup();
            codeStream.ifeq(actionLabel);
            this.expression.generateCode(currentScope, codeStream, true);
            codeStream.checkcast(this.type, this.type.resolvedType, codeStream.position);
            codeStream.store(this.elementVariable.binding, false);
            codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
            actionLabel.place();
        }
        if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    @Override
    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        this.expression.printExpression(indent, output).append(" instanceof ");
        return this.elementVariable == null ? this.type.print(0, output) : this.elementVariable.printAsExpression(0, output);
    }

    @Override
    public void initializePatternVariables(BlockScope currentScope, CodeStream codeStream) {
        if (this.elementVariable != null) {
            if (!this.isInitialized) {
                this.isInitialized = true;
                codeStream.aconst_null();
                codeStream.store(this.elementVariable.binding, false);
            }
            int position = codeStream.position;
            codeStream.addVisibleLocalVariable(this.elementVariable.binding);
            this.elementVariable.binding.recordInitializationStartPC(position);
        }
    }

    public void resolvePatternVariable(BlockScope scope) {
        if (this.elementVariable != null && this.elementVariable.binding == null) {
            this.elementVariable.resolve(scope, true);
            this.elementVariable.binding.modifiers |= 0x10000000;
            this.elementVariable.binding.useFlag = 1;
            this.type = this.elementVariable.type;
        }
    }

    @Override
    public boolean containsPatternVariable() {
        return this.elementVariable != null;
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        TypeBinding expressionType;
        this.constant = Constant.NotAConstant;
        this.resolvePatternVariable(scope);
        TypeBinding checkedType = this.type.resolveType(scope, true);
        if (this.expression instanceof CastExpression) {
            ((CastExpression)this.expression).setInstanceofType(checkedType);
        }
        if ((expressionType = this.expression.resolveType(scope)) != null && checkedType != null && this.type.hasNullTypeAnnotation(TypeReference.AnnotationPosition.ANY) && (!expressionType.isCompatibleWith(checkedType) || NullAnnotationMatching.analyse(checkedType, expressionType, -1).isAnyMismatch())) {
            scope.problemReporter().nullAnnotationUnsupportedLocation(this.type);
        }
        if (expressionType == null || checkedType == null) {
            return null;
        }
        if (!checkedType.isReifiable()) {
            scope.problemReporter().illegalInstanceOfGenericType(checkedType, this);
        } else if (checkedType.isValidBinding() && (expressionType != TypeBinding.NULL && expressionType.isBaseType() || checkedType.isBaseType() || !this.checkCastTypesCompatibility(scope, checkedType, expressionType, null, true))) {
            scope.problemReporter().notCompatibleTypesError(this, expressionType, checkedType);
        }
        this.resolvedType = TypeBinding.BOOLEAN;
        return this.resolvedType;
    }

    @Override
    public void tagAsUnnecessaryCast(Scope scope, TypeBinding castType) {
        if (this.expression.resolvedType != TypeBinding.NULL) {
            scope.problemReporter().unnecessaryInstanceof(this, castType);
        }
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
            if (this.elementVariable != null) {
                this.elementVariable.traverse(visitor, scope);
            } else {
                this.type.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }
}

