/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.view.constraint;

import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.vcd.IVcdDiagram;
import fr.inria.aoste.timesquare.vcd.figure.ConstraintsConnection;
import fr.inria.aoste.timesquare.vcd.model.comment.Moderator;
import fr.inria.aoste.timesquare.vcd.view.constraint.AbsConstraint;
import fr.inria.aoste.timesquare.vcd.view.constraint.IConstraint;
import fr.inria.aoste.timesquare.vcd.view.figure.Draw1;
import fr.inria.aoste.timesquare.vcd.view.figure.ExtendFigure;
import java.util.ArrayList;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class ConstraintAlternates
extends AbsConstraint
implements IConstraint {
    boolean flagdraw = true;

    public ConstraintAlternates() {
        this.testn = 1;
    }

    @Override
    public int draw(Draw1 currentfig, String currentclock) {
        Moderator md;
        String getAclk = this.cc.getClock();
        String getBclk = this.cc.getReferenceClocks().get(0);
        int v1 = 1;
        int v2 = 1;
        if (this.cc.getReferenceClocks().size() == 3) {
            v1 = Integer.valueOf(this.cc.getReferenceClocks().get(1));
            v2 = Integer.valueOf(this.cc.getReferenceClocks().get(2));
        }
        if ((md = this.cc.getModerator()) == null) {
            md = Moderator.weakly;
        }
        int index = this.getIndice(currentclock, currentfig);
        if (getAclk.equals(currentclock)) {
            int pack = index / v1;
            int a1 = pack * v1;
            int an = (pack + 1) * v1 - 1;
            int bn = pack * v2 - 1;
            int b1 = pack * v2;
            this.connect(this.getTick(getAclk, an), this.getTick(getBclk, b1), md.is_rightWeakly());
            this.connect(this.getTick(getBclk, bn), this.getTick(getAclk, a1), md.is_leftWeakly());
            this.drawPacket(this.getTick(getAclk, a1), this.getTick(getAclk, an));
            if (this.flagdraw) {
                this.drawPacket(this.getTick(getBclk, bn - v2 + 1), this.getTick(getBclk, bn));
            }
            this.drawPacket(this.getTick(getBclk, b1), this.getTick(getBclk, b1 + v2 - 1));
        } else {
            int pack = index / v2;
            int a1 = (pack + 1) * v1;
            int an = (pack + 1) * v1 - 1;
            int bn = (pack + 1) * v2 - 1;
            int b1 = pack * v2;
            this.connect(this.getTick(getBclk, bn), this.getTick(getAclk, a1), md.is_leftWeakly());
            this.connect(this.getTick(getAclk, an), this.getTick(getBclk, b1), md.is_rightWeakly());
            this.drawPacket(this.getTick(getBclk, b1), this.getTick(getBclk, bn));
            this.drawPacket(this.getTick(getAclk, an - v1 + 1), this.getTick(getAclk, an));
            this.drawPacket(this.getTick(getAclk, a1), this.getTick(getAclk, a1 + v1 - 1));
        }
        return 0;
    }

    private void drawPacket(IFigure f1, IFigure f2) {
        if (f1 == null) {
            return;
        }
        if (f2 == null) {
            return;
        }
        ArrayList<ConstraintsConnection> packet = this.icc.constructPacket(this.mca.colorBlueSustain(), (Draw1)f1, (Draw1)f2);
        for (ConstraintsConnection c : packet) {
            c.setGlobal(this.isGlobal);
            c.setComment(this.cc);
            this.icc.addToList(this.list.getListConstraints(), c);
        }
    }

    private void connect(ExtendFigure source, ExtendFigure target, boolean empty) {
        if (source == null || target == null) {
            return;
        }
        Color color = this.mca.colorWhiteArrow();
        if (source.getBounds().x == target.getBounds().x) {
            color = this.mca.colorWeakyCoincidence();
        }
        ConstraintsConnection poly = this.icc.constructDashConnection(color, (Draw1)source, (Draw1)target, empty);
        poly.setComment(this.cc);
        poly.setGlobal(this.isGlobal);
        this.icc.addToList(this.list.getListConstraints(), poly);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int drawTableItemConstraints() {
        String nameClock;
        block7: {
            this.isGlobal = true;
            nameClock = this.cc.getClock();
            int v1 = 1;
            this.flagdraw = false;
            if (this.cc.getReferenceClocks().size() == 3) {
                v1 = Integer.valueOf(this.cc.getReferenceClocks().get(1));
            }
            if (this.haveAllClockVisible()) {
                void var4_6;
                ArrayList<ExtendFigure> lfig = this.vcdFactory.getNameforfigures().get(nameClock);
                boolean bl = false;
                while (var4_6 < lfig.size()) {
                    IFigure fig = lfig.get((int)var4_6);
                    this.draw((Draw1)fig, nameClock);
                    var4_6 += v1;
                }
                break block7;
            }
            return -1;
        }
        try {
            IVcdDiagram vdt = this.vcdFactory.getVcddia();
            for (IFigure iFigure : this.list.getListConstraints()) {
                Dimension dim = vdt.getCanvas().getContents().getPreferredSize();
                vdt.getCanvas().getContents().add(iFigure);
                Rectangle bounds = iFigure.getBounds();
                vdt.getCanvas().redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
                vdt.getCanvas().getContents().setPreferredSize(dim);
            }
            this.isConstraintVisible = true;
            this.isGlobal = false;
            this.flagdraw = true;
            return this.vcdFactory.getNameforfigures().get(nameClock).size();
        }
        catch (Throwable t) {
            this.isGlobal = false;
            ErrorConsole.printError((Throwable)t);
            this.flagdraw = true;
            return -1;
        }
    }

    @Override
    public int drawOneTick(int ticknum, String clockId) {
        return 0;
    }
}

