/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p5edges;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.intermediate.LayoutProcessorStrategy;
import de.cau.cs.kieler.klay.layered.p5edges.OrthogonalRoutingGenerator;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class OrthogonalEdgeRouter
extends AbstractAlgorithm
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration HYPEREDGE_PROCESSING_ADDITIONS = new IntermediateProcessingConfiguration(3, LayoutProcessorStrategy.HYPEREDGE_DUMMY_MERGER);
    private static final IntermediateProcessingConfiguration INVERTED_PORT_PROCESSING_ADDITIONS = new IntermediateProcessingConfiguration(2, LayoutProcessorStrategy.INVERTED_PORT_PROCESSOR);
    private static final IntermediateProcessingConfiguration NORTH_SOUTH_PORT_PROCESSING_ADDITIONS = new IntermediateProcessingConfiguration(null, null, EnumSet.of(LayoutProcessorStrategy.NORTH_SOUTH_PORT_PREPROCESSOR), null, null, EnumSet.of(LayoutProcessorStrategy.NORTH_SOUTH_PORT_POSTPROCESSOR));
    private static final IntermediateProcessingConfiguration HIERARCHICAL_PORT_PROCESSING_ADDITIONS = new IntermediateProcessingConfiguration(null, null, EnumSet.of(LayoutProcessorStrategy.HIERARCHICAL_PORT_CONSTRAINT_PROCESSOR), null, EnumSet.of(LayoutProcessorStrategy.HIERARCHICAL_PORT_DUMMY_SIZE_PROCESSOR), EnumSet.of(LayoutProcessorStrategy.HIERARCHICAL_PORT_ORTHOGONAL_EDGE_ROUTER));
    private static final IntermediateProcessingConfiguration SELF_LOOP_PROCESSING_ADDITIONS = new IntermediateProcessingConfiguration(2, LayoutProcessorStrategy.SELF_LOOP_PROCESSOR);
    private static final IntermediateProcessingConfiguration HYPERNODE_PROCESSING_ADDITIONS = new IntermediateProcessingConfiguration(5, LayoutProcessorStrategy.HYPERNODE_PROCESSOR);

    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        Set graphProperties = (Set)graph.getProperty(Properties.GRAPH_PROPERTIES);
        IntermediateProcessingConfiguration configuration = new IntermediateProcessingConfiguration();
        if (graphProperties.contains((Object)GraphProperties.HYPEREDGES)) {
            configuration.addAll(HYPEREDGE_PROCESSING_ADDITIONS);
            configuration.addAll(INVERTED_PORT_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.NON_FREE_PORTS)) {
            configuration.addAll(INVERTED_PORT_PROCESSING_ADDITIONS);
            if (graphProperties.contains((Object)GraphProperties.NORTH_SOUTH_PORTS)) {
                configuration.addAll(NORTH_SOUTH_PORT_PROCESSING_ADDITIONS);
            }
        }
        if (graphProperties.contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            configuration.addAll(HIERARCHICAL_PORT_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.SELF_LOOPS)) {
            configuration.addAll(SELF_LOOP_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.HYPERNODES)) {
            configuration.addAll(HYPERNODE_PROCESSING_ADDITIONS);
        }
        return configuration;
    }

    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Orthogonal edge routing", 1.0f);
        double nodeSpacing = ((Float)layeredGraph.getProperty((IProperty)Properties.OBJ_SPACING)).floatValue();
        double edgeSpacing = nodeSpacing * (double)((Float)layeredGraph.getProperty((IProperty)Properties.EDGE_SPACING_FACTOR)).floatValue();
        boolean debug = (Boolean)layeredGraph.getProperty(LayoutOptions.DEBUG_MODE);
        OrthogonalRoutingGenerator routingGenerator = new OrthogonalRoutingGenerator(new OrthogonalRoutingGenerator.WestToEastRoutingStrategy(), edgeSpacing, debug ? "phase5" : null);
        float xpos = 0.0f;
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        Layer leftLayer = null;
        Layer rightLayer = null;
        List<LNode> leftLayerNodes = null;
        List<LNode> rightLayerNodes = null;
        int leftLayerIndex = -1;
        int rightLayerIndex = -1;
        do {
            int slotsCount;
            rightLayer = layerIter.hasNext() ? layerIter.next() : null;
            rightLayerNodes = rightLayer == null ? null : rightLayer.getNodes();
            rightLayerIndex = layerIter.previousIndex();
            if (leftLayer != null) {
                leftLayer.placeNodes(xpos);
                xpos = (float)((double)xpos + (leftLayer.getSize().x + nodeSpacing));
            }
            if ((slotsCount = routingGenerator.routeEdges(layeredGraph, leftLayerNodes, leftLayerIndex, rightLayerNodes, xpos)) > 0) {
                xpos = (float)((double)xpos + ((double)slotsCount * edgeSpacing - edgeSpacing + nodeSpacing));
            }
            leftLayer = rightLayer;
            leftLayerNodes = rightLayerNodes;
            leftLayerIndex = rightLayerIndex;
        } while (rightLayer != null);
        layeredGraph.getSize().x = xpos;
        this.getMonitor().done();
    }
}

