/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p3order;

import de.cau.cs.kieler.klay.layered.graph.LNode;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeGroup
implements Comparable<NodeGroup> {
    public float summedWeight;
    public int degree;
    public Float barycenter;
    public int incomingConstraintsCount;
    public boolean visited;
    private final LNode[] nodes;
    private List<NodeGroup> outgoingConstraints;
    private List<NodeGroup> incomingConstraints;

    public NodeGroup(LNode node) {
        this.nodes = new LNode[]{node};
    }

    public NodeGroup(NodeGroup nodeGroup1, NodeGroup nodeGroup2) {
        int length1 = nodeGroup1.nodes.length;
        int length2 = nodeGroup2.nodes.length;
        this.nodes = new LNode[length1 + length2];
        int i = 0;
        while (i < length1) {
            this.nodes[i] = nodeGroup1.nodes[i];
            ++i;
        }
        i = 0;
        while (i < length2) {
            this.nodes[length1 + i] = nodeGroup2.nodes[i];
            ++i;
        }
        if (nodeGroup1.outgoingConstraints != null) {
            this.outgoingConstraints = new LinkedList<NodeGroup>(nodeGroup1.outgoingConstraints);
            this.outgoingConstraints.remove(nodeGroup2);
            if (nodeGroup2.outgoingConstraints != null) {
                for (NodeGroup candidate : nodeGroup2.outgoingConstraints) {
                    if (candidate == nodeGroup1) continue;
                    if (this.outgoingConstraints.contains(candidate)) {
                        --candidate.incomingConstraintsCount;
                        continue;
                    }
                    this.outgoingConstraints.add(candidate);
                }
            }
        } else if (nodeGroup2.outgoingConstraints != null) {
            this.outgoingConstraints = new LinkedList<NodeGroup>(nodeGroup2.outgoingConstraints);
            this.outgoingConstraints.remove(nodeGroup1);
        }
        this.summedWeight = nodeGroup1.summedWeight + nodeGroup2.summedWeight;
        this.degree = nodeGroup1.degree + nodeGroup2.degree;
        if (this.degree > 0) {
            this.barycenter = Float.valueOf(this.summedWeight / (float)this.degree);
        } else if (nodeGroup1.barycenter != null && nodeGroup2.barycenter != null) {
            this.barycenter = Float.valueOf((nodeGroup1.barycenter.floatValue() + nodeGroup2.barycenter.floatValue()) / 2.0f);
        } else if (nodeGroup1.barycenter != null) {
            this.barycenter = nodeGroup1.barycenter;
        } else if (nodeGroup2.barycenter != null) {
            this.barycenter = nodeGroup2.barycenter;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int i = 0;
        while (i < this.nodes.length) {
            sb.append(this.nodes[i].toString());
            if (this.barycenter != null) {
                sb.append("<").append(this.barycenter.toString()).append(">");
            }
            if (i < this.nodes.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.append(']').toString();
    }

    public List<NodeGroup> getOutgoingConstraints() {
        if (this.outgoingConstraints == null) {
            this.outgoingConstraints = new LinkedList<NodeGroup>();
        }
        return this.outgoingConstraints;
    }

    public void resetOutgoingConstraints() {
        this.outgoingConstraints = null;
    }

    public boolean hasOutgoingConstraints() {
        return this.outgoingConstraints != null && this.outgoingConstraints.size() > 0;
    }

    public List<NodeGroup> getIncomingConstraints() {
        if (this.incomingConstraints == null) {
            this.incomingConstraints = new LinkedList<NodeGroup>();
        }
        return this.incomingConstraints;
    }

    public void resetIncomingConstraints() {
        this.incomingConstraints = null;
    }

    public boolean hasIncomingConstraints() {
        return this.incomingConstraints != null && this.incomingConstraints.size() > 0;
    }

    public LNode[] getNodes() {
        return this.nodes;
    }

    public LNode getNode() {
        assert (this.nodes.length == 1);
        return this.nodes[0];
    }

    @Override
    public int compareTo(NodeGroup other) {
        if (this.barycenter != null && other.barycenter != null) {
            return this.barycenter.compareTo(other.barycenter);
        }
        if (this.barycenter != null) {
            return -1;
        }
        if (other.barycenter != null) {
            return 1;
        }
        return 0;
    }
}

