/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.gmf;

import de.cau.cs.kieler.core.kgraph.KGraphData;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.Property;
import de.cau.cs.kieler.core.util.Maybe;
import de.cau.cs.kieler.kiml.LayoutContext;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.config.DefaultLayoutConfig;
import de.cau.cs.kieler.kiml.config.IMutableLayoutConfig;
import de.cau.cs.kieler.kiml.gmf.GmfDiagramLayoutManager;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.ui.service.EclipseLayoutConfig;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GmfLayoutConfig
implements IMutableLayoutConfig {
    public static final int PRIORITY = 30;
    public static final String PREFIX = "layout:";
    public static final String DEF_PREFIX = "defaultLayout:";
    public static final IProperty<View> NOTATION_VIEW = new Property("context.notationView");
    private static final float ASPECT_RATIO_ROUND = 100.0f;

    public static boolean isNoLayout(EditPart editPart) {
        Boolean result;
        if (editPart instanceof IGraphicalEditPart && (result = (Boolean)EclipseLayoutConfig.getValue((IProperty)LayoutOptions.NO_LAYOUT, (Object)editPart, (EObject)((IGraphicalEditPart)editPart).getNotationView().getElement())) != null) {
            return result;
        }
        return false;
    }

    public int getPriority() {
        return 30;
    }

    public void enrich(LayoutContext context) {
        Object editPart = context.getProperty(LayoutContext.DIAGRAM_PART);
        if (editPart instanceof IGraphicalEditPart && !GmfLayoutConfig.isNoLayout((EditPart)editPart)) {
            Maybe hasPorts;
            Maybe containerEditPart;
            Set<LayoutOptionData.Target> partTargets;
            IGraphicalEditPart focusEditPart = (IGraphicalEditPart)editPart;
            if (focusEditPart instanceof CompartmentEditPart) {
                focusEditPart = (IGraphicalEditPart)focusEditPart.getParent();
                context.setProperty(LayoutContext.DIAGRAM_PART, (Object)focusEditPart);
            }
            View notationView = focusEditPart.getNotationView();
            context.setProperty(NOTATION_VIEW, (Object)notationView);
            if (context.getProperty(LayoutContext.DOMAIN_MODEL) == null) {
                EObject object = notationView.getElement();
                if (focusEditPart.getParent() == null || !(focusEditPart.getParent().getModel() instanceof View) || ((View)focusEditPart.getParent().getModel()).getElement() != object) {
                    context.setProperty(LayoutContext.DOMAIN_MODEL, (Object)object);
                }
            }
            if ((partTargets = this.findTarget(focusEditPart, (Maybe<IGraphicalEditPart>)(containerEditPart = Maybe.create()), (Maybe<Boolean>)(hasPorts = Maybe.create()))) != null) {
                context.setProperty(LayoutContext.OPT_TARGETS, partTargets);
            }
            if (hasPorts.get() != null) {
                context.setProperty(DefaultLayoutConfig.HAS_PORTS, hasPorts.get());
            }
            try {
                Control control;
                EditPartViewer viewer = focusEditPart.getViewer();
                if (viewer != null && (control = viewer.getControl()) != null) {
                    Point size = control.getSize();
                    if (size.x > 0 && size.y > 0) {
                        context.setProperty(EclipseLayoutConfig.ASPECT_RATIO, (Object)Float.valueOf((float)Math.round(100.0f * (float)size.x / (float)size.y) / 100.0f));
                    }
                }
            }
            catch (SWTException sWTException) {}
            if (((Boolean)context.getProperty(DefaultLayoutConfig.OPT_MAKE_OPTIONS)).booleanValue()) {
                DiagramEditPart diagramEditPart = GmfDiagramLayoutManager.getDiagramEditPart((EditPart)focusEditPart);
                LayoutOptionData algorithmOptionData = LayoutDataService.getInstance().getOptionData(LayoutOptions.ALGORITHM.getId());
                if (context.getProperty(DefaultLayoutConfig.CONTENT_HINT) == null && algorithmOptionData != null) {
                    String contentLayoutHint = (String)this.getValue(algorithmOptionData, PREFIX, notationView);
                    if (contentLayoutHint == null) {
                        contentLayoutHint = (String)this.getValue(algorithmOptionData, DEF_PREFIX, diagramEditPart.getNotationView());
                    }
                    if (contentLayoutHint != null) {
                        context.setProperty(DefaultLayoutConfig.CONTENT_HINT, (Object)contentLayoutHint);
                    }
                }
                if (containerEditPart.get() != null) {
                    if (context.getProperty(DefaultLayoutConfig.CONTAINER_HINT) == null) {
                        String containerLayoutHint = (String)this.getValue(algorithmOptionData, PREFIX, ((IGraphicalEditPart)containerEditPart.get()).getNotationView());
                        if (containerLayoutHint == null) {
                            containerLayoutHint = (String)this.getValue(algorithmOptionData, DEF_PREFIX, diagramEditPart.getNotationView());
                        }
                        if (containerLayoutHint != null) {
                            context.setProperty(DefaultLayoutConfig.CONTAINER_HINT, (Object)containerLayoutHint);
                        }
                    }
                    context.setProperty(LayoutContext.CONTAINER_DIAGRAM_PART, containerEditPart.get());
                    EObject object = ((IGraphicalEditPart)containerEditPart.get()).getNotationView().getElement();
                    if (object != null) {
                        context.setProperty(LayoutContext.CONTAINER_DOMAIN_MODEL, (Object)object);
                    }
                }
            }
        }
    }

    protected Set<LayoutOptionData.Target> findTarget(IGraphicalEditPart editPart, Maybe<IGraphicalEditPart> containerEditPart, Maybe<Boolean> hasPorts) {
        EnumSet<LayoutOptionData.Target> partTarget = null;
        if (editPart instanceof AbstractBorderItemEditPart) {
            partTarget = EnumSet.of(LayoutOptionData.Target.PORTS);
            containerEditPart.set((Object)((IGraphicalEditPart)editPart.getParent().getParent()));
        } else if (editPart instanceof ShapeNodeEditPart) {
            partTarget = EnumSet.of(LayoutOptionData.Target.NODES);
            containerEditPart.set((Object)((IGraphicalEditPart)editPart.getParent()));
            if (GmfLayoutConfig.findContainingEditPart(editPart, hasPorts) != null) {
                partTarget.add(LayoutOptionData.Target.PARENTS);
            }
        } else if (editPart instanceof ConnectionEditPart) {
            partTarget = EnumSet.of(LayoutOptionData.Target.EDGES);
            EditPart sourcePart = ((ConnectionEditPart)editPart).getSource();
            EditPart parentPart = sourcePart instanceof AbstractBorderItemEditPart ? sourcePart.getParent().getParent() : sourcePart.getParent();
            if (parentPart instanceof IGraphicalEditPart) {
                containerEditPart.set((Object)((IGraphicalEditPart)parentPart));
            }
        } else if (editPart instanceof LabelEditPart) {
            partTarget = EnumSet.of(LayoutOptionData.Target.LABELS);
            containerEditPart.set((Object)((IGraphicalEditPart)editPart.getParent()));
            if (containerEditPart.get() instanceof ConnectionEditPart) {
                EditPart sourcePart = ((ConnectionEditPart)containerEditPart.get()).getSource();
                if (sourcePart instanceof AbstractBorderItemEditPart) {
                    containerEditPart.set((Object)((IGraphicalEditPart)sourcePart.getParent().getParent()));
                } else {
                    containerEditPart.set((Object)((IGraphicalEditPart)sourcePart.getParent()));
                }
            } else if (containerEditPart.get() instanceof AbstractBorderItemEditPart) {
                containerEditPart.set((Object)((IGraphicalEditPart)((IGraphicalEditPart)containerEditPart.get()).getParent().getParent()));
            } else if (containerEditPart.get() instanceof ShapeNodeEditPart) {
                containerEditPart.set((Object)((IGraphicalEditPart)((IGraphicalEditPart)containerEditPart.get()).getParent()));
            }
        } else if (editPart instanceof DiagramEditPart) {
            partTarget = EnumSet.of(LayoutOptionData.Target.PARENTS);
        }
        if (containerEditPart.get() instanceof CompartmentEditPart) {
            containerEditPart.set((Object)((IGraphicalEditPart)((IGraphicalEditPart)containerEditPart.get()).getParent()));
        }
        return partTarget;
    }

    private static IGraphicalEditPart findContainingEditPart(IGraphicalEditPart editPart, Maybe<Boolean> hasPorts) {
        hasPorts.set((Object)Boolean.FALSE);
        for (Object child : editPart.getChildren()) {
            if (child instanceof AbstractBorderItemEditPart && !GmfLayoutConfig.isNoLayout((EditPart)child)) {
                hasPorts.set((Object)Boolean.TRUE);
                continue;
            }
            if (child instanceof ShapeNodeEditPart && !(child instanceof AbstractBorderItemEditPart) && !GmfLayoutConfig.isNoLayout((EditPart)child)) {
                return editPart;
            }
            if (!(child instanceof CompartmentEditPart) || GmfLayoutConfig.isNoLayout((EditPart)child)) continue;
            for (Object grandChild : ((CompartmentEditPart)child).getChildren()) {
                if (!(grandChild instanceof ShapeNodeEditPart) || GmfLayoutConfig.isNoLayout((EditPart)grandChild)) continue;
                return (IGraphicalEditPart)child;
            }
        }
        return null;
    }

    public Object getValue(LayoutOptionData<?> optionData, LayoutContext context) {
        DiagramEditPart diagramEditPart;
        Object result;
        View view = (View)context.getProperty(NOTATION_VIEW);
        if (view != null && (result = this.getValue(optionData, PREFIX, view)) != null) {
            return result;
        }
        Object editPart = context.getProperty(LayoutContext.DIAGRAM_PART);
        if (editPart instanceof EditPart && (diagramEditPart = GmfDiagramLayoutManager.getDiagramEditPart((EditPart)editPart)) != null) {
            return this.getValue(optionData, DEF_PREFIX, diagramEditPart.getNotationView());
        }
        return null;
    }

    private <T> T getValue(LayoutOptionData<T> optionData, String prefix, View view) {
        String optionKey = String.valueOf(prefix) + optionData.getId();
        for (Object obj : view.getStyles()) {
            Object result;
            StringValueStyle style;
            if (!(obj instanceof StringValueStyle) || !optionKey.equals((style = (StringValueStyle)obj).getName()) || (result = optionData.parseValue(style.getStringValue())) == null) continue;
            return (T)result;
        }
        return null;
    }

    public void transferValues(KGraphData graphData, LayoutContext context) {
        Object editPart = context.getProperty(LayoutContext.DIAGRAM_PART);
        if (editPart instanceof IGraphicalEditPart) {
            DiagramEditPart diagramEditPart = GmfDiagramLayoutManager.getDiagramEditPart((EditPart)editPart);
            if (diagramEditPart != null) {
                this.transferValues(graphData, DEF_PREFIX, diagramEditPart.getNotationView());
            }
            this.transferValues(graphData, PREFIX, ((IGraphicalEditPart)editPart).getNotationView());
        } else {
            View view = (View)context.getProperty(NOTATION_VIEW);
            if (view != null) {
                this.transferValues(graphData, PREFIX, view);
            }
        }
    }

    private void transferValues(KGraphData graphData, String prefix, View view) {
        LayoutDataService layoutServices = LayoutDataService.getInstance();
        for (Object obj : view.getStyles()) {
            Object value;
            LayoutOptionData optionData;
            StringValueStyle style;
            String key;
            if (!(obj instanceof StringValueStyle) || (key = (style = (StringValueStyle)obj).getName()) == null || !key.startsWith(prefix) || (optionData = layoutServices.getOptionData(key.substring(prefix.length()))) == null || (value = optionData.parseValue(style.getStringValue())) == null) continue;
            graphData.setProperty((IProperty)optionData, value);
        }
    }

    public void setValue(LayoutOptionData<?> optionData, LayoutContext context, Object value) {
        View view = (View)context.getProperty(NOTATION_VIEW);
        if (view != null) {
            if (((Boolean)context.getProperty(IMutableLayoutConfig.OPT_RECURSIVE)).booleanValue()) {
                if (value != null) {
                    this.removeValue(optionData, PREFIX, view, true);
                }
                this.setValue(optionData, value, DEF_PREFIX, view);
            } else {
                this.setValue(optionData, value, PREFIX, view);
            }
        }
    }

    private void setValue(LayoutOptionData<?> optionData, Object value, String prefix, View view) {
        if (value == null) {
            this.removeValue(optionData, prefix, view, false);
        } else {
            String optionKey = String.valueOf(prefix) + optionData.getId();
            for (Object obj : view.getStyles()) {
                StringValueStyle style;
                if (!(obj instanceof StringValueStyle) || !optionKey.equals((style = (StringValueStyle)obj).getName())) continue;
                style.setStringValue(value.toString());
                return;
            }
            StringValueStyle style = NotationFactory.eINSTANCE.createStringValueStyle();
            style.setName(optionKey);
            style.setStringValue(value.toString());
            view.getStyles().add((Object)style);
        }
    }

    private void removeValue(LayoutOptionData<?> optionData, String prefix, View view, boolean recursive) {
        String optionKey = String.valueOf(prefix) + optionData.getId();
        Iterator iter = view.getStyles().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof StringValueStyle) || !optionKey.equals(((StringValueStyle)obj).getName())) continue;
            iter.remove();
        }
        if (recursive) {
            for (Object child : view.getPersistedChildren()) {
                this.removeValue(optionData, prefix, (View)child, true);
                if (!(child instanceof Diagram)) continue;
                for (Object edge : ((Diagram)child).getPersistedEdges()) {
                    this.removeValue(optionData, prefix, (View)edge, true);
                }
            }
        }
    }

    public void clearValues(LayoutContext context) {
        View view = (View)context.getProperty(NOTATION_VIEW);
        if (view != null) {
            boolean recursive = (Boolean)context.getProperty(IMutableLayoutConfig.OPT_RECURSIVE);
            this.clearValues(view, recursive);
        }
    }

    private void clearValues(View view, boolean recursive) {
        Iterator iter = view.getStyles().iterator();
        while (iter.hasNext()) {
            String key;
            Object obj = iter.next();
            if (!(obj instanceof StringValueStyle)) continue;
            StringValueStyle style = (StringValueStyle)obj;
            String string = key = style.getName() == null ? "" : style.getName();
            if (!key.startsWith(PREFIX) && !key.startsWith(DEF_PREFIX)) continue;
            iter.remove();
        }
        if (recursive) {
            for (Object child : view.getPersistedChildren()) {
                this.clearValues((View)child, true);
            }
            if (view instanceof Diagram) {
                for (Object child : ((Diagram)view).getPersistedEdges()) {
                    this.clearValues((View)child, true);
                }
            }
        }
    }

    public boolean isSet(LayoutOptionData<?> optionData, LayoutContext context) {
        View view = (View)context.getProperty(NOTATION_VIEW);
        if (view != null) {
            Object result = this.getValue(optionData, PREFIX, view);
            return result != null;
        }
        return false;
    }
}

