/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.force.model;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.force.graph.FBendpoint;
import de.cau.cs.kieler.klay.force.graph.FEdge;
import de.cau.cs.kieler.klay.force.graph.FGraph;
import de.cau.cs.kieler.klay.force.graph.FLabel;
import de.cau.cs.kieler.klay.force.graph.FNode;
import de.cau.cs.kieler.klay.force.graph.FParticle;
import de.cau.cs.kieler.klay.force.properties.Properties;
import java.util.List;
import java.util.Random;

public abstract class AbstractForceModel
extends AbstractAlgorithm {
    private Random random;
    private FGraph graph;
    private double dispBound;
    private static final double DISP_BOUND_FACTOR = 16.0;

    protected void initialize(FGraph fgraph) {
        this.graph = fgraph;
        this.random = (Random)fgraph.getProperty(Properties.RANDOM);
        fgraph.calcAdjacency();
        this.dispBound = Math.max((double)fgraph.getNodes().size() * 16.0 + (double)fgraph.getEdges().size(), 256.0);
        if (!((Boolean)fgraph.getProperty(LayoutOptions.INTERACTIVE)).booleanValue()) {
            double posScale = this.graph.getNodes().size();
            for (FNode node : fgraph.getNodes()) {
                KVector pos = node.getPosition();
                pos.x = this.random.nextDouble() * posScale;
                pos.y = this.random.nextDouble() * posScale;
            }
        }
        List<FBendpoint> bends = fgraph.getBendpoints();
        for (FEdge edge : fgraph.getEdges()) {
            int count = (Integer)edge.getProperty((IProperty)Properties.EDGE_REP);
            if (count <= 0) continue;
            int i = 0;
            while (i < count) {
                bends.add(new FBendpoint(edge));
                ++i;
            }
            edge.distributeBendpoints();
        }
    }

    public final FGraph getGraph() {
        return this.graph;
    }

    protected final Random getRandom() {
        return this.random;
    }

    public void layout(FGraph fgraph) {
        this.getMonitor().begin("Component Layout", 1.0f);
        this.initialize(fgraph);
        int iterations = 0;
        while (this.moreIterations(iterations) && !this.getMonitor().isCanceled()) {
            for (FNode v : fgraph.getNodes()) {
                for (FParticle u : fgraph.getParticles()) {
                    KVector displacement;
                    if (u == v || (displacement = this.calcDisplacement(u, v)) == null) continue;
                    v.getDisplacement().add(displacement);
                }
            }
            for (FNode v : fgraph.getNodes()) {
                KVector d = v.getDisplacement();
                d.applyBounds(-this.dispBound, -this.dispBound, this.dispBound, this.dispBound);
                v.getPosition().add(d);
                d.reset();
            }
            this.iterationDone();
            ++iterations;
        }
        this.getMonitor().done();
    }

    protected void iterationDone() {
        for (FEdge edge : this.graph.getEdges()) {
            for (FLabel label : edge.getLabels()) {
                label.refreshPosition();
            }
            edge.distributeBendpoints();
        }
    }

    protected abstract boolean moreIterations(int var1);

    protected abstract KVector calcDisplacement(FParticle var1, FParticle var2);

    public static void avoidSamePosition(Random random, FParticle u, FParticle v) {
        KVector pu = u.getPosition();
        KVector pv = v.getPosition();
        while (pu.x - pv.x == 0.0 && pu.y - pv.y == 0.0) {
            pu.wiggle(random, 1.0);
            pv.wiggle(random, 1.0);
        }
    }
}

