/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.scoping;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.InSemanticsRule;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.fSM.OutSemanticsRule;
import org.eclipse.etrice.core.fsm.fSM.SemanticsRule;
import org.eclipse.etrice.core.fsm.fSM.Trigger;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.InMessageHandler;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.OutMessageHandler;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefSAPoint;
import org.eclipse.etrice.core.room.RelaySAPoint;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.SPPoint;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class RoomScopeProviderDelegate {
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;

    public IScope getScope(EObject context, EReference reference) {
        IScope iScope = null;
        try {
            IScope iScope2;
            iScope = iScope2 = this.scopeFor(context, reference);
        }
        catch (Throwable throwable) {
            if (throwable instanceof NullPointerException || throwable instanceof IllegalArgumentException) {
                iScope = null;
            }
            throw Exceptions.sneakyThrow((Throwable)throwable);
        }
        return iScope;
    }

    protected IScope _scopeFor(EObject obj, EReference ref) {
        return null;
    }

    protected IScope _scopeFor(Trigger trigger, EReference ref) {
        IScope iScope = null;
        boolean bl = false;
        if (Objects.equals(ref, FSMPackage.Literals.MESSAGE_FROM_IF__MESSAGE)) {
            bl = true;
            iScope = this.scopeTriggerMessages(this._roomHelpers.getAllInterfaceItems(this._roomHelpers.getActorClass((EObject)trigger)));
        }
        if (!bl) {
            iScope = this.emptyScope();
        }
        return iScope;
    }

    protected IScope _scopeFor(MessageFromIf mfi, EReference ref) {
        IScope iScope = null;
        boolean bl = false;
        if (Objects.equals(ref, FSMPackage.Literals.MESSAGE_FROM_IF__MESSAGE)) {
            bl = true;
            IScope iScope2 = null;
            AbstractInterfaceItem abstractInterfaceItem = mfi.getFrom();
            InterfaceItem item = (InterfaceItem)abstractInterfaceItem;
            IScope iScope3 = null;
            iScope3 = item != null ? this.scopeTriggerMessages(Collections.singletonList(item)) : this.scopeTriggerMessages(this._roomHelpers.getAllInterfaceItems(this._roomHelpers.getActorClass((EObject)mfi)));
            iScope = iScope2 = iScope3;
        }
        if (!bl && Objects.equals(ref, FSMPackage.Literals.MESSAGE_FROM_IF__FROM)) {
            bl = true;
            iScope = this.simpleScope(this._roomHelpers.getAllInterfaceItems(this._roomHelpers.getActorClass((EObject)mfi)));
        }
        if (!bl) {
            iScope = this.emptyScope();
        }
        return iScope;
    }

    private IScope scopeTriggerMessages(List<InterfaceItem> ifitems) {
        Functions.Function1 function1 = it -> {
            List<Message> list = null;
            boolean bl = false;
            if (it instanceof Port) {
                bl = true;
                ProtocolClass protocolClass = ((Port)it).getProtocol();
                boolean bl2 = ((Port)it).isConjugated();
                boolean bl3 = !bl2;
                list = this._roomHelpers.getAllMessages(protocolClass, bl3);
            }
            if (!bl && it instanceof SAP) {
                bl = true;
                list = this._roomHelpers.getAllMessages(((SAP)it).getProtocol(), false);
            }
            if (!bl && it instanceof SPP) {
                bl = true;
                list = this._roomHelpers.getAllMessages(((SPP)it).getProtocol(), true);
            }
            if (!bl) {
                list = CollectionLiterals.emptyList();
            }
            return list;
        };
        return this.simpleScope(IterableExtensions.flatMap(ifitems, (Functions.Function1)function1));
    }

    protected IScope _scopeFor(Binding binding, EReference ref) {
        IScope iScope = null;
        boolean bl = false;
        if (Objects.equals(ref, RoomPackage.Literals.BINDING_END_POINT__ACTOR_REF)) {
            bl = true;
            iScope = this.scopeBindingActorRef(this._roomHelpers.getStructureClass(binding));
        }
        if (!bl && Objects.equals(ref, RoomPackage.Literals.BINDING_END_POINT__PORT)) {
            bl = true;
            iScope = this.scopeBindingPort(this._roomHelpers.getStructureClass(binding), null);
        }
        if (!bl) {
            iScope = this.emptyScope();
        }
        return iScope;
    }

    protected IScope _scopeFor(BindingEndPoint ep, EReference ref) {
        IScope iScope = null;
        boolean bl = false;
        if (Objects.equals(ref, RoomPackage.Literals.BINDING_END_POINT__ACTOR_REF)) {
            bl = true;
            iScope = this.scopeBindingActorRef(this._roomHelpers.getStructureClass(ep));
        }
        if (!bl && Objects.equals(ref, RoomPackage.Literals.BINDING_END_POINT__PORT)) {
            bl = true;
            iScope = this.scopeBindingPort(this._roomHelpers.getStructureClass(ep), ep.getActorRef());
        }
        if (!bl) {
            iScope = this.emptyScope();
        }
        return iScope;
    }

    private IScope scopeBindingActorRef(StructureClass sc) {
        boolean bl = false;
        if (sc instanceof ActorClass) {
            bl = true;
            Functions.Function1 function1 = it -> it.getActorRefs();
            return this.simpleScope(IterableExtensions.flatMap(this._roomHelpers.getClassHierarchy((ActorClass)sc), (Functions.Function1)function1));
        }
        if (!bl && sc instanceof SubSystemClass) {
            bl = true;
            return this.simpleScope((Iterable<? extends EObject>)((SubSystemClass)sc).getActorRefs());
        }
        if (!bl && sc instanceof LogicalSystem) {
            bl = true;
            return this.simpleScope((Iterable<? extends EObject>)((LogicalSystem)sc).getSubSystems());
        }
        return null;
    }

    private IScope scopeBindingPort(StructureClass sc, ActorContainerRef actorRef) {
        if (actorRef == null) {
            if (sc instanceof ActorClass) {
                Functions.Function1 function1 = it -> {
                    EList<Port> eList = it.getInternalPorts();
                    EList<Port> eList2 = it.getRelayPorts();
                    return Iterables.concat(eList, eList2);
                };
                return this.simpleScope(IterableExtensions.flatMap(this._roomHelpers.getClassHierarchy((ActorClass)sc), (Functions.Function1)function1));
            }
            if (sc instanceof SubSystemClass) {
                return this.simpleScope((Iterable<? extends EObject>)((SubSystemClass)sc).getRelayPorts());
            }
        } else {
            ActorContainerRef epref = actorRef;
            boolean bl = false;
            if (epref instanceof ActorRef) {
                bl = true;
                Functions.Function1 function1 = it -> it.getInterfacePorts();
                return this.simpleScope(IterableExtensions.flatMap(this._roomHelpers.getClassHierarchy(((ActorRef)epref).getType()), (Functions.Function1)function1));
            }
            if (!bl && epref instanceof SubSystemRef) {
                bl = true;
                return this.simpleScope((Iterable<? extends EObject>)((SubSystemRef)epref).getType().getRelayPorts());
            }
        }
        return null;
    }

    protected IScope _scopeFor(SemanticsRule sr, EReference ref) {
        ProtocolClass pc = this._roomHelpers.getProtocolClass((EObject)sr);
        if (sr instanceof InSemanticsRule) {
            Functions.Function1 function1 = it -> it.getIncomingMessages();
            return this.simpleScope(IterableExtensions.flatMap(this._roomHelpers.getClassHierarchy(pc), (Functions.Function1)function1));
        }
        if (sr instanceof OutSemanticsRule) {
            Functions.Function1 function1 = it -> it.getOutgoingMessages();
            return this.simpleScope(IterableExtensions.flatMap(this._roomHelpers.getClassHierarchy(pc), (Functions.Function1)function1));
        }
        return this.emptyScope();
    }

    protected IScope _scopeFor(RefSAPoint pt, EReference ref) {
        ActorContainerClass acc = this._roomHelpers.getActorContainerClass(pt);
        if (acc instanceof ActorClass) {
            Functions.Function1 function1 = it -> it.getActorRefs();
            return this.simpleScope(IterableExtensions.flatMap(this._roomHelpers.getClassHierarchy((ActorClass)acc), (Functions.Function1)function1));
        }
        return this.simpleScope((Iterable<? extends EObject>)acc.getActorRefs());
    }

    protected IScope _scopeFor(RelaySAPoint pt, EReference ref) {
        boolean bl = Objects.equals(ref, RoomPackage.Literals.RELAY_SA_POINT__RELAY);
        if (bl) {
            Functions.Function1 function1 = it -> it.getServiceProvisionPoints();
            return this.simpleScope(IterableExtensions.flatMap(this._roomHelpers.getClassHierarchy(this._roomHelpers.getActorClass(pt)), (Functions.Function1)function1));
        }
        return this.emptyScope();
    }

    protected IScope _scopeFor(SPPoint pt, EReference ref) {
        boolean bl = false;
        if (Objects.equals(ref, RoomPackage.Literals.SP_POINT__REF)) {
            bl = true;
            ActorContainerClass acc = this._roomHelpers.getActorContainerClass(pt);
            if (acc instanceof ActorClass) {
                Functions.Function1 function1 = it -> it.getActorRefs();
                return this.simpleScope(IterableExtensions.flatMap(this._roomHelpers.getClassHierarchy((ActorClass)acc), (Functions.Function1)function1));
            }
            return this.simpleScope((Iterable<? extends EObject>)acc.getActorRefs());
        }
        if (!bl && Objects.equals(ref, RoomPackage.Literals.SP_POINT__SERVICE)) {
            bl = true;
            ActorContainerRef sppref = pt.getRef();
            if (sppref instanceof ActorRef) {
                Functions.Function1 function1 = it -> it.getServiceProvisionPoints();
                return this.simpleScope(IterableExtensions.flatMap(this._roomHelpers.getClassHierarchy(((ActorRef)sppref).getType()), (Functions.Function1)function1));
            }
            if (sppref instanceof SubSystemRef) {
                return this.simpleScope((Iterable<? extends EObject>)((SubSystemRef)sppref).getType().getServiceProvisionPoints());
            }
        }
        return this.emptyScope();
    }

    protected IScope _scopeFor(MessageHandler handler, EReference ref) {
        ProtocolClass pc;
        boolean bl = Objects.equals(ref, RoomPackage.Literals.MESSAGE_HANDLER__MSG);
        if (bl && (pc = this._roomHelpers.getProtocolClass(handler)) != null) {
            if (handler instanceof InMessageHandler) {
                return this.simpleScope((Iterable<? extends EObject>)pc.getIncomingMessages());
            }
            if (handler instanceof OutMessageHandler) {
                return this.simpleScope((Iterable<? extends EObject>)pc.getOutgoingMessages());
            }
        }
        return this.emptyScope();
    }

    protected IScope _scopeFor(PortOperation op, EReference ref) {
        EObject eObject = op.eContainer();
        PortClass pcls = (PortClass)eObject;
        ProtocolClass pc = this._roomHelpers.getProtocolClass(op);
        if (pc != null) {
            boolean bl;
            PortClass portClass = pc.getConjugated();
            boolean bl2 = bl = pcls == portClass;
            if (bl) {
                return this.simpleScope((Iterable<? extends EObject>)pc.getIncomingMessages());
            }
            return this.simpleScope((Iterable<? extends EObject>)pc.getOutgoingMessages());
        }
        return this.emptyScope();
    }

    protected IScope _scopeFor(ExternalPort ep, EReference ref) {
        return this.simpleScope((Iterable<? extends EObject>)this._roomHelpers.getActorClass(ep).getInterfacePorts());
    }

    protected IScope emptyScope() {
        return IScope.NULLSCOPE;
    }

    protected IScope simpleScope(Iterable<? extends EObject> elements) {
        return Scopes.scopeFor((Iterable)ImmutableList.copyOf(elements));
    }

    protected IScope scopeFor(EObject op, EReference ref) {
        if (op instanceof PortOperation) {
            return this._scopeFor((PortOperation)op, ref);
        }
        if (op instanceof RefSAPoint) {
            return this._scopeFor((RefSAPoint)op, ref);
        }
        if (op instanceof RelaySAPoint) {
            return this._scopeFor((RelaySAPoint)op, ref);
        }
        if (op instanceof Binding) {
            return this._scopeFor((Binding)op, ref);
        }
        if (op instanceof BindingEndPoint) {
            return this._scopeFor((BindingEndPoint)op, ref);
        }
        if (op instanceof ExternalPort) {
            return this._scopeFor((ExternalPort)op, ref);
        }
        if (op instanceof MessageHandler) {
            return this._scopeFor((MessageHandler)op, ref);
        }
        if (op instanceof SPPoint) {
            return this._scopeFor((SPPoint)op, ref);
        }
        if (op instanceof MessageFromIf) {
            return this._scopeFor((MessageFromIf)op, ref);
        }
        if (op instanceof SemanticsRule) {
            return this._scopeFor((SemanticsRule)op, ref);
        }
        if (op instanceof Trigger) {
            return this._scopeFor((Trigger)op, ref);
        }
        if (op != null) {
            return this._scopeFor(op, ref);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(op, ref).toString());
    }
}

