/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.converter;

import org.eclipse.etrice.core.common.converter.CCStringIndentation;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;

public class CCStringConverter
extends AbstractLexerBasedConverter<String> {
    private final String delim;

    public static String addDelim(String text, String delim) {
        if (CCStringIndentation.hasLineBreak(text)) {
            String lineEnding = CCStringIndentation.firstLineSeparator(text);
            return delim + lineEnding + text + delim;
        }
        return delim + text + delim;
    }

    public static String stripDelim(String nodeText, String delim) {
        if (nodeText.startsWith(delim) && nodeText.endsWith(delim)) {
            return nodeText.substring(delim.length(), nodeText.length() - delim.length());
        }
        return nodeText;
    }

    public CCStringConverter(String delim) {
        this.delim = delim;
    }

    public String getDelim() {
        return this.delim;
    }

    protected String toEscapedString(String value) {
        return CCStringConverter.addDelim(value, this.delim);
    }

    public String toValue(String string, INode node) {
        if (string == null) {
            return null;
        }
        try {
            return new CCStringIndentation(CCStringConverter.stripDelim(string, this.delim)).removeEditorWhiteSpace();
        }
        catch (IllegalArgumentException e) {
            throw new ValueConverterException(e.getMessage(), node, (Exception)e);
        }
    }

    public String addDelim(String text) {
        return CCStringConverter.addDelim(text, this.delim);
    }

    public String stripDelim(String text) {
        return CCStringConverter.stripDelim(text, this.delim);
    }
}

