/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.converter;

import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class MultiplicityConverter
extends AbstractValueConverter<Integer> {
    public Integer toValue(String string, INode node) {
        if (Strings.isEmpty((String)string)) {
            throw new ValueConverterException("Couldn't convert empty string to integer.", node, null);
        }
        if (string.indexOf("*") >= 0) {
            return -1;
        }
        int first = 0;
        while (first < string.length()) {
            if (Character.isDigit(string.charAt(first))) break;
            ++first;
        }
        int last = first;
        while (last < string.length()) {
            if (!Character.isDigit(string.charAt(last))) break;
            ++last;
        }
        String val = string.substring(first, last);
        try {
            int intValue = Integer.parseInt(val);
            if (intValue <= 0) {
                throw new ValueConverterException("multiplicity must be positive or any [*]", node, null);
            }
            return intValue;
        }
        catch (NumberFormatException e) {
            throw new ValueConverterException("Couldn't convert '" + val + "' to integer.", node, (Exception)e);
        }
    }

    public String toString(Integer value) throws ValueConverterException {
        if (value == -1) {
            return "[*]";
        }
        return "[" + value.toString() + "]";
    }
}

