/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ide.server;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.common.ide.modelpath.ModelPathManager;
import org.eclipse.etrice.generator.base.io.IModelPath;
import org.eclipse.etrice.generator.base.io.ResourceSetModelPathProvider;
import org.eclipse.xtext.ide.server.ProjectManager;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;

public class ModelProjectManager
extends ProjectManager {
    private static final Logger LOG = Logger.getLogger(ModelProjectManager.class);
    @Inject
    private ModelPathManager modelpathManager;

    public XtextResourceSet createNewResourceSet(ResourceDescriptionsData newIndex) {
        XtextResourceSet resourceSet = super.createNewResourceSet(newIndex);
        resourceSet.eAdapters().add((Object)new ResourceAddedAdapter());
        return resourceSet;
    }

    protected XtextResourceSet createFreshResourceSet(ResourceDescriptionsData newIndex) {
        XtextResourceSet resourceSet = super.createFreshResourceSet(newIndex);
        if (this.getBaseDir() != null) {
            IModelPath modelpath = this.modelpathManager.getModelPath(this.getBaseDir().toString());
            ResourceSetModelPathProvider.install((ResourceSet)resourceSet, (IModelPath)modelpath);
        }
        return resourceSet;
    }

    private class ResourceAddedAdapter
    extends AdapterImpl {
        private ResourceAddedAdapter() {
        }

        public void notifyChanged(Notification msg) {
            if (msg.getEventType() == 3) {
                Resource addedResource = (Resource)msg.getNewValue();
                LOG.debug((Object)("Project " + ModelProjectManager.this.getProjectDescription().getName() + " loaded resource " + String.valueOf(addedResource.getURI())));
            }
        }
    }
}

