/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.fsm.support.util;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.fsm.fSM.ChoicePoint;
import org.eclipse.etrice.core.fsm.fSM.ChoicepointTerminal;
import org.eclipse.etrice.core.fsm.fSM.FSMFactory;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.RefinedState;
import org.eclipse.etrice.core.fsm.fSM.RefinedTransition;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateGraphItem;
import org.eclipse.etrice.core.fsm.fSM.StateTerminal;
import org.eclipse.etrice.core.fsm.fSM.SubStateTrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.TrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.TransitionTerminal;
import org.eclipse.etrice.core.fsm.naming.FSMNameProvider;
import org.eclipse.etrice.core.fsm.ui.FSMUiModule;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.core.fsm.util.FSMNewNamingUtil;
import org.eclipse.etrice.core.fsm.validation.FSMValidationUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public class FSMSupportUtil {
    private static FSMSupportUtil instance = null;
    @Inject
    private FSMHelpers fsmHelpers;
    @Inject
    private FSMValidationUtil fsmValidationUtil;
    @Inject
    private FSMNameProvider fsmNameProvider;
    @Inject
    private FSMNewNamingUtil fsmNewNamingUtil;

    public static FSMSupportUtil getInstance() {
        if (instance == null) {
            Injector injector = FSMUiModule.getInjector();
            instance = (FSMSupportUtil)injector.getInstance(FSMSupportUtil.class);
        }
        return instance;
    }

    public FSMHelpers getFSMHelpers() {
        return this.fsmHelpers;
    }

    public FSMValidationUtil getFSMValidationUtil() {
        return this.fsmValidationUtil;
    }

    public FSMNewNamingUtil getFSMNewNamingUtil() {
        return this.fsmNewNamingUtil;
    }

    public FSMNameProvider getFSMNameProvider() {
        return this.fsmNameProvider;
    }

    public boolean isInherited(Diagram diag, EObject obj) {
        return this.isInherited(this.getModelComponent(diag), obj);
    }

    public boolean isInherited(ModelComponent mc, EObject obj) {
        if (obj instanceof StateGraph) {
            obj = obj.eContainer();
        } else if (obj instanceof ModelComponent) {
            return ((ModelComponent)obj).getBase() != null;
        }
        return obj instanceof RefinedState || obj instanceof RefinedTransition || !EcoreUtil.isAncestor((EObject)mc, (EObject)obj);
    }

    public boolean isOwnedBy(Diagram diag, EObject obj) {
        return this.isOwnedBy(this.getModelComponent(diag), obj);
    }

    public boolean isOwnedBy(ModelComponent mc, EObject obj) {
        return EcoreUtil.isAncestor((EObject)mc, (EObject)obj);
    }

    public boolean showAsInherited(Diagram diag, State obj) {
        if (obj instanceof RefinedState) {
            return true;
        }
        return this.fsmHelpers.getModelComponent((StateGraphItem)obj) != this.getModelComponent(diag);
    }

    public Diagram getDiagram(GraphicsAlgorithm ga) {
        if (ga.eContainer() instanceof GraphicsAlgorithm) {
            return this.getDiagram((GraphicsAlgorithm)ga.eContainer());
        }
        return this.getDiagram(ga.getPictogramElement());
    }

    public Diagram getDiagram(PictogramElement pe) {
        while (pe.eContainer() != null) {
            if (pe.eContainer() instanceof Diagram) {
                return (Diagram)pe.eContainer();
            }
            pe = (PictogramElement)pe.eContainer();
        }
        return null;
    }

    public ModelComponent getModelComponent(Diagram diag) {
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)diag);
        if (bo instanceof ModelComponent) {
            return (ModelComponent)bo;
        }
        return null;
    }

    public State getTargettingState(State state, Diagram diagram) {
        ModelComponent mc = this.getModelComponent(diagram);
        return this.fsmHelpers.getTargettingState(state, mc);
    }

    public ContainerShape getStateGraphContainer(ContainerShape shape) {
        while (shape != null) {
            ContainerShape parent = shape.getContainer();
            if (parent instanceof Diagram) {
                return shape;
            }
            shape = parent;
        }
        return null;
    }

    public StateGraph getStateGraph(ContainerShape cs, IFeatureProvider fp) {
        ContainerShape shape = this.getStateGraphContainer(cs);
        Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)shape);
        if (bo instanceof StateGraph) {
            return (StateGraph)bo;
        }
        assert (false) : "state graph expected";
        return null;
    }

    public TransitionTerminal getTransitionTerminal(Anchor anchor, IFeatureProvider fp) {
        if (anchor != null) {
            Object obj = fp.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent());
            if (obj instanceof TrPoint) {
                Object parent = fp.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)anchor.getParent().eContainer()));
                if (parent instanceof State) {
                    State state = parent instanceof RefinedState ? ((RefinedState)parent).getTarget() : (State)parent;
                    SubStateTrPointTerminal sstpt = FSMFactory.eINSTANCE.createSubStateTrPointTerminal();
                    sstpt.setState(state);
                    sstpt.setTrPoint((TrPoint)obj);
                    return sstpt;
                }
                TrPointTerminal tpt = FSMFactory.eINSTANCE.createTrPointTerminal();
                tpt.setTrPoint((TrPoint)obj);
                return tpt;
            }
            if (obj instanceof State) {
                State state = obj instanceof RefinedState ? ((RefinedState)obj).getTarget() : (State)obj;
                StateTerminal st = FSMFactory.eINSTANCE.createStateTerminal();
                st.setState(state);
                return st;
            }
            if (obj instanceof ChoicePoint) {
                ChoicepointTerminal ct = FSMFactory.eINSTANCE.createChoicepointTerminal();
                ct.setCp((ChoicePoint)obj);
                return ct;
            }
        }
        return null;
    }

    public boolean isInitialPoint(Anchor anchor, IFeatureProvider fp) {
        Object parent;
        Object obj;
        return anchor != null && (obj = fp.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof StateGraph && (parent = fp.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)anchor.getParent().eContainer()))) instanceof StateGraph;
    }

    public boolean canConnect(Anchor asrc, Anchor atgt, ContainerShape cs, IFeatureProvider fp) {
        return this.canConnect(asrc, atgt, null, cs, fp);
    }

    public boolean canConnect(Anchor asrc, Anchor atgt, Transition trans, ContainerShape cs, IFeatureProvider fp) {
        TransitionTerminal src = this.getTransitionTerminal(asrc, fp);
        TransitionTerminal tgt = this.getTransitionTerminal(atgt, fp);
        if (src == null && !this.isInitialPoint(asrc, fp)) {
            return false;
        }
        if (tgt == null) {
            return false;
        }
        StateGraph sg = this.getStateGraph(cs, fp);
        if (sg == null) {
            return false;
        }
        return this.fsmValidationUtil.isConnectable(src, tgt, trans, sg).isOk();
    }

    public List<Transition> getTransitions(Diagram diagram, IFeatureProvider fp) {
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        for (Connection conn : diagram.getConnections()) {
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)conn);
            if (!(bo instanceof Transition)) continue;
            transitions.add((Transition)bo);
        }
        return transitions;
    }
}

