/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.common;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.console.common.ConsoleInputStream;
import org.eclipse.equinox.console.common.KEYS;
import org.eclipse.equinox.console.telnet.ANSITerminalTypeMappings;
import org.eclipse.equinox.console.telnet.SCOTerminalTypeMappings;
import org.eclipse.equinox.console.telnet.TerminalTypeMappings;
import org.eclipse.equinox.console.telnet.VT100TerminalTypeMappings;
import org.eclipse.equinox.console.telnet.VT220TerminalTypeMappings;
import org.eclipse.equinox.console.telnet.VT320TerminalTypeMappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Scanner {
    protected static final byte BS = 8;
    protected byte BACKSPACE;
    protected static final byte LF = 10;
    protected static final byte CR = 13;
    protected static final byte ESC = 27;
    protected static final byte SPACE = 32;
    protected byte DEL;
    protected static final byte MAX_CHAR = 127;
    protected static final String DEFAULT_TTYPE = File.separatorChar == '/' ? "XTERM" : "ANSI";
    protected OutputStream toTelnet;
    protected ConsoleInputStream toShell;
    protected Map<String, KEYS> currentEscapesToKey;
    protected final Map<String, TerminalTypeMappings> supportedEscapeSequences;
    protected String[] escapes;
    protected String esc;
    protected boolean isEsc = false;

    public Scanner(ConsoleInputStream toShell, OutputStream toTelnet) {
        this.toShell = toShell;
        this.toTelnet = toTelnet;
        this.supportedEscapeSequences = new HashMap<String, TerminalTypeMappings>();
        this.supportedEscapeSequences.put("ANSI", new ANSITerminalTypeMappings());
        this.supportedEscapeSequences.put("VT100", new VT100TerminalTypeMappings());
        VT220TerminalTypeMappings vtMappings = new VT220TerminalTypeMappings();
        this.supportedEscapeSequences.put("VT220", new VT220TerminalTypeMappings());
        this.supportedEscapeSequences.put("XTERM", vtMappings);
        this.supportedEscapeSequences.put("VT320", new VT320TerminalTypeMappings());
        this.supportedEscapeSequences.put("SCO", new SCOTerminalTypeMappings());
    }

    public abstract void scan(int var1) throws IOException;

    protected void echo(int b) throws IOException {
        this.toTelnet.write(b);
    }

    protected void flush() throws IOException {
        this.toTelnet.flush();
    }

    protected KEYS checkEscape(String possibleEsc) {
        if (this.currentEscapesToKey.get(possibleEsc) != null) {
            return this.currentEscapesToKey.get(possibleEsc);
        }
        String[] stringArray = this.escapes;
        int n = this.escapes.length;
        int n2 = 0;
        while (n2 < n) {
            String escape = stringArray[n2];
            if (escape.startsWith(possibleEsc)) {
                return KEYS.UNFINISHED;
            }
            ++n2;
        }
        return KEYS.UNKNOWN;
    }

    protected void startEsc() {
        this.isEsc = true;
        this.esc = "";
    }

    protected abstract void scanEsc(int var1) throws IOException;

    public byte getBackspace() {
        return this.BACKSPACE;
    }

    public void setBackspace(byte backspace) {
        this.BACKSPACE = backspace;
    }

    public byte getDel() {
        return this.DEL;
    }

    public void setDel(byte del) {
        this.DEL = del;
    }

    public Map<String, KEYS> getCurrentEscapesToKey() {
        return this.currentEscapesToKey;
    }

    public void setCurrentEscapesToKey(Map<String, KEYS> currentEscapesToKey) {
        this.currentEscapesToKey = currentEscapesToKey;
    }

    public String[] getEscapes() {
        return this.escapes;
    }

    public void setEscapes(String[] escapes) {
        this.escapes = escapes;
    }
}

