/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.osgi.util.NLS;

public class Util {
    static /* synthetic */ Class class$0;

    public static void log(String message) {
        LogHelper.log((IStatus)Util.createError(message));
    }

    public static IStatus createError(String message) {
        return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", message);
    }

    public static String getInstallFolder(IProfile profile) {
        return profile.getProperty("org.eclipse.equinox.p2.installFolder");
    }

    private static IAgentLocation getAgentLocation(IProvisioningAgent agent) {
        return (IAgentLocation)agent.getService(IAgentLocation.SERVICE_NAME);
    }

    public static IArtifactRepositoryManager getArtifactRepositoryManager(IProvisioningAgent agent) {
        return (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
    }

    public static IFileArtifactRepository getDownloadCacheRepo(IProvisioningAgent agent) throws ProvisionException {
        IFileArtifactRepository downloadCache;
        Class<?> clazz;
        IArtifactRepository repository;
        URI location = Util.getDownloadCacheLocation(agent);
        if (location == null) {
            throw new IllegalStateException(Messages.could_not_obtain_download_cache);
        }
        IArtifactRepositoryManager manager = Util.getArtifactRepositoryManager(agent);
        if (manager == null) {
            throw new IllegalStateException(Messages.artifact_repo_not_found);
        }
        try {
            repository = manager.loadRepository(location, null);
        }
        catch (ProvisionException provisionException) {
            String repositoryName = location + " - Agent download cache";
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("p2.system", Boolean.TRUE.toString());
            repository = manager.createRepository(location, repositoryName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((downloadCache = (IFileArtifactRepository)repository.getAdapter((Class)clazz)) == null) {
            throw new ProvisionException(NLS.bind((String)Messages.download_cache_not_writeable, (Object)location));
        }
        return downloadCache;
    }

    private static URI getDownloadCacheLocation(IProvisioningAgent agent) {
        IAgentLocation location = Util.getAgentLocation(agent);
        if (location == null) {
            return null;
        }
        return URIUtil.append((URI)location.getDataArea("org.eclipse.equinox.p2.core"), (String)"cache/");
    }

    public static File[] unzipFile(File zipFile, File outputDir, IBackupStore store, String taskName, IProgressMonitor monitor) throws IOException {
        FileInputStream in = new FileInputStream(zipFile);
        try {
            File[] fileArray = Util.unzipStream(in, zipFile.length(), outputDir, store, taskName, monitor);
            return fileArray;
        }
        catch (IOException e) {
            throw new IOException(NLS.bind((String)Messages.Util_Error_Unzipping, (Object)zipFile, (Object)e.getMessage()));
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static File[] unzipStream(InputStream stream, long size, File outputDir, IBackupStore store, String taskName, IProgressMonitor monitor) throws IOException {
        InputStream is = monitor == null ? stream : stream;
        ZipInputStream in = new ZipInputStream(new BufferedInputStream(is));
        ZipEntry ze = in.getNextEntry();
        if (ze == null) {
            in.close();
            throw new IOException(Messages.Util_Invalid_Zip_File_Format);
        }
        ArrayList<File> unzippedFiles = new ArrayList<File>();
        do {
            File outFile = new File(outputDir, ze.getName());
            unzippedFiles.add(outFile);
            if (ze.isDirectory()) {
                outFile.mkdirs();
            } else {
                if (outFile.exists()) {
                    if (store != null) {
                        store.backup(outFile);
                    } else {
                        outFile.delete();
                    }
                } else {
                    outFile.getParentFile().mkdirs();
                }
                try {
                    Util.copyStream(in, false, new FileOutputStream(outFile), true);
                }
                catch (FileNotFoundException fileNotFoundException) {}
                outFile.setLastModified(ze.getTime());
            }
            in.closeEntry();
        } while ((ze = in.getNextEntry()) != null);
        in.close();
        return unzippedFiles.toArray(new File[unzippedFiles.size()]);
    }

    public static int copyStream(InputStream in, boolean closeIn, OutputStream out, boolean closeOut) throws IOException {
        try {
            int len;
            int written = 0;
            byte[] buffer = new byte[16384];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                written += len;
            }
            int n = written;
            return n;
        }
        finally {
            try {
                if (closeIn) {
                    in.close();
                }
            }
            finally {
                if (closeOut) {
                    out.close();
                }
            }
        }
    }
}

