/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.reconcile;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.internal.common.reconcile.Reconciler;

public interface Copier {
    public static final Copier NEVER_COPY = new Copier(){

        @Override
        public EObject copyToCurrent(EObject currentParent, EObject old, Reconciler reconciler) {
            return null;
        }
    };
    public static final Copier COMPLETE_COPY_NO_CROSSREF = new Copier(){

        @Override
        public EObject copyToCurrent(EObject currentParent, EObject old, Reconciler reconciler) {
            this.safetyCheck(old);
            EClass currentParentEClass = currentParent.eClass();
            EObject oldParent = old.eContainer();
            EClass oldParentEClass = oldParent.eClass();
            EObject currentCopy = null;
            if (currentParentEClass.equals(oldParentEClass)) {
                currentCopy = EcoreUtil.copy((EObject)old);
                EStructuralFeature containment = old.eContainingFeature();
                Object currentValue = currentParent.eGet(containment);
                if (currentValue instanceof Collection) {
                    Collection asCollection = (Collection)currentValue;
                    asCollection.add(currentCopy);
                } else {
                    currentParent.eSet(containment, (Object)currentCopy);
                }
            }
            return currentCopy;
        }

        private void safetyCheck(EObject old) {
            if (!EcoreUtil.CrossReferencer.find(Collections.singleton(old)).isEmpty()) {
                throw new IllegalArgumentException("I am not intended to copy elements with cross references");
            }
        }
    };
    public static final Copier COMPLETE_COPY_WITH_CROSSREF = new WithCrossRefsCopier();

    public EObject copyToCurrent(EObject var1, EObject var2, Reconciler var3);

    public static class WithCrossRefsCopier
    implements Copier {
        @Override
        public EObject copyToCurrent(EObject currentParent, EObject old, Reconciler reconciler) {
            Map crossReferences = EcoreUtil.CrossReferencer.find(Collections.singleton(old));
            EClass currentParentEClass = currentParent.eClass();
            EObject oldParent = old.eContainer();
            EClass oldParentEClass = oldParent.eClass();
            EObject currentCopy = null;
            if (currentParentEClass.equals(oldParentEClass)) {
                currentCopy = EcoreUtil.copy((EObject)old);
                EStructuralFeature containment = old.eContainingFeature();
                Object currentValue = currentParent.eGet(containment);
                if (currentValue instanceof Collection) {
                    Collection asCollection = (Collection)currentValue;
                    asCollection.add(currentCopy);
                } else {
                    currentParent.eSet(containment, (Object)currentCopy);
                }
                reconciler.registerCrossReferencesToUpdate(crossReferences);
            }
            return currentCopy;
        }
    }
}

