/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.Scrollable;

class ScrollablePicture
extends JLabel
implements Scrollable,
MouseMotionListener {
    private int maxUnitIncrement = 1;
    private boolean missingPicture = false;

    public ScrollablePicture(ImageIcon i, int m) {
        super(i);
        if (i == null) {
            this.missingPicture = true;
            this.setText("No picture found.");
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
            this.setBackground(Color.white);
        }
        this.maxUnitIncrement = m;
        this.setAutoscrolls(true);
        this.addMouseMotionListener(this);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Rectangle r = new Rectangle(e.getX(), e.getY(), 1, 1);
        this.scrollRectToVisible(r);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.missingPicture) {
            return new Dimension(320, 480);
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int currentPosition = 0;
        currentPosition = orientation == 0 ? visibleRect.x : visibleRect.y;
        if (direction < 0) {
            int newPosition = currentPosition - currentPosition / this.maxUnitIncrement * this.maxUnitIncrement;
            return newPosition == 0 ? this.maxUnitIncrement : newPosition;
        }
        return (currentPosition / this.maxUnitIncrement + 1) * this.maxUnitIncrement - currentPosition;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width - this.maxUnitIncrement;
        }
        return visibleRect.height - this.maxUnitIncrement;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void setMaxUnitIncrement(int pixels) {
        this.maxUnitIncrement = pixels;
    }
}

