/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.mindmap;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.mindmap.Finger;
import net.sourceforge.plantuml.mindmap.FingerImpl;
import net.sourceforge.plantuml.mindmap.Idea;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.StyleBuilder;

class Branch
implements UDrawable {
    private Idea root;
    private Idea last;
    private Finger finger;

    Branch() {
    }

    void initRoot(StyleBuilder styleBuilder, HColor backColor, Display label, IdeaShape shape, String stereotype) {
        this.last = this.root = Idea.createIdeaSimple(styleBuilder, backColor, label, shape, stereotype);
    }

    void initFinger(ISkinParam skinParam, boolean direction) {
        this.finger = FingerImpl.build(this.root, skinParam, direction);
    }

    Idea getParentOfLast(int nb) {
        Idea result = this.last;
        for (int i = 0; i < nb; ++i) {
            result = result.getParent();
        }
        return result;
    }

    CommandExecutionResult add(StyleBuilder styleBuilder, HColor backColor, int level, Display label, IdeaShape shape, String stereotype) {
        if (this.last == null) {
            return CommandExecutionResult.error("Check your indentation ?");
        }
        if (level == this.last.getLevel() + 1) {
            Idea newIdea;
            this.last = newIdea = this.last.createIdea(styleBuilder, backColor, level, label, shape, stereotype);
            return CommandExecutionResult.ok();
        }
        if (level <= this.last.getLevel()) {
            Idea newIdea;
            int diff = this.last.getLevel() - level + 1;
            this.last = newIdea = this.getParentOfLast(diff).createIdea(styleBuilder, backColor, level, label, shape, stereotype);
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("error42L");
    }

    public boolean hasFinger() {
        return this.finger != null;
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.finger != null) {
            this.finger.drawU(ug);
        }
    }

    public double getHalfThickness(StringBounder stringBounder) {
        if (this.finger == null) {
            return 0.0;
        }
        return this.finger.getFullThickness(stringBounder) / 2.0;
    }

    public double getFullElongation(StringBounder stringBounder) {
        if (this.finger == null) {
            return 0.0;
        }
        return this.finger.getFullElongation(stringBounder);
    }

    public boolean hasChildren() {
        return this.root.hasChildren();
    }

    public boolean hasRoot() {
        return this.root != null;
    }

    public void doNotDrawFirstPhalanx() {
        this.finger.doNotDrawFirstPhalanx();
    }

    public double getX12(StringBounder stringBounder) {
        if (this.finger == null) {
            return 0.0;
        }
        return this.finger.getFullElongation(stringBounder) + ((FingerImpl)this.finger).getX12();
    }
}

