/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.schema.Constant;
import org.h2.schema.Schema;

public class DropConstant
extends SchemaCommand {
    private String constantName;
    private boolean ifExists;

    public DropConstant(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setConstantName(String string) {
        this.constantName = string;
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Constant constant = this.getSchema().findConstant(this.constantName);
        if (constant == null) {
            if (!this.ifExists) {
                throw Message.getSQLException(90115, this.constantName);
            }
        } else {
            database.removeSchemaObject(this.session, constant);
        }
        return 0;
    }
}

