/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.atlas.iterator.IteratorWrapper;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.sparql.engine.iterator.Abortable;

public class IterAbortable<T>
extends IteratorWrapper<T>
implements Abortable,
IteratorCloseable<T> {
    private volatile boolean abortFlag = false;
    private boolean haveAborted = false;

    public IterAbortable(Iterator<T> iterator) {
        super(iterator);
    }

    @Override
    public void abort() {
        this.abortFlag = true;
    }

    private void execAbort() {
        if (!this.haveAborted) {
            this.close();
        }
        this.haveAborted = true;
    }

    @Override
    public boolean hasNext() {
        if (this.abortFlag) {
            this.execAbort();
            throw new QueryCancelledException();
        }
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        if (this.abortFlag) {
            this.execAbort();
            throw new QueryCancelledException();
        }
        return (T)this.iterator.next();
    }

    @Override
    public void remove() {
        if (this.abortFlag) {
            this.execAbort();
            throw new QueryCancelledException();
        }
        this.iterator.remove();
    }
}

