/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system.stream;

import java.util.StringTokenizer;
import org.apache.jena.JenaRuntime;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.system.stream.LocationMapper;
import org.apache.jena.riot.system.stream.LocatorClassLoader;
import org.apache.jena.riot.system.stream.LocatorFile;
import org.apache.jena.riot.system.stream.StreamManager;
import org.apache.jena.shared.JenaException;
import org.apache.jena.vocabulary.LocationMappingVocab;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenaIOEnvironment {
    static LocationMapper theMapper = null;
    private static final Object lock = new Object();
    static Logger log = LoggerFactory.getLogger(JenaIOEnvironment.class);
    public static final String DEFAULT_PATH = "location-mapping.ttl;location-mapping.rdf;etc/location-mapping.rdf;etc/location-mapping.ttl";
    public static final String GlobalMapperSystemProperty1 = "http://jena.hpl.hp.com/2004/08/LocationMap";
    public static final String GlobalMapperSystemProperty2 = "LocationMap";
    static String s_globalMapperPath = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocationMapper getLocationMapper() {
        Object object = lock;
        synchronized (object) {
            if (theMapper == null) {
                String path = JenaIOEnvironment.getGlobalConfigPath();
                if (path != null) {
                    theMapper = JenaIOEnvironment.createLocationMapper(path);
                }
                if (theMapper == null) {
                    theMapper = new LocationMapper();
                }
            }
            return theMapper;
        }
    }

    private static String getGlobalConfigPath() {
        if (s_globalMapperPath == null) {
            s_globalMapperPath = JenaRuntime.getSystemProperty(GlobalMapperSystemProperty1, null);
        }
        if (s_globalMapperPath == null) {
            s_globalMapperPath = JenaRuntime.getSystemProperty(GlobalMapperSystemProperty2, null);
        }
        if (s_globalMapperPath == null) {
            s_globalMapperPath = DEFAULT_PATH;
        }
        return s_globalMapperPath;
    }

    public static void setGlobalLocationMapper(LocationMapper globalLocationMapper) {
        theMapper = globalLocationMapper;
    }

    public static LocationMapper makeGlobal() {
        LocationMapper lMap = new LocationMapper();
        if (JenaIOEnvironment.getGlobalConfigPath() != null) {
            LocationMapper lMap2 = JenaIOEnvironment.createLocationMapper(JenaIOEnvironment.getGlobalConfigPath());
            lMap.copyFrom(lMap2);
        }
        return lMap;
    }

    public static LocationMapper processConfig(Model m) {
        LocationMapper locMap = new LocationMapper();
        StmtIterator mappings = m.listStatements(null, LocationMappingVocab.mapping, (RDFNode)null);
        while (mappings.hasNext()) {
            Statement s = mappings.nextStatement();
            Resource mapping = s.getResource();
            if (mapping.hasProperty(LocationMappingVocab.name)) {
                try {
                    String name = mapping.getRequiredProperty(LocationMappingVocab.name).getString();
                    String altName = mapping.getRequiredProperty(LocationMappingVocab.altName).getString();
                    locMap.addAltEntry(name, altName);
                    log.debug("Mapping: " + name + " => " + altName);
                }
                catch (JenaException ex) {
                    log.warn("Error processing name mapping: " + ex.getMessage());
                    throw ex;
                }
            }
            if (!mapping.hasProperty(LocationMappingVocab.prefix)) continue;
            try {
                String prefix = mapping.getRequiredProperty(LocationMappingVocab.prefix).getString();
                String altPrefix = mapping.getRequiredProperty(LocationMappingVocab.altPrefix).getString();
                locMap.addAltPrefix(prefix, altPrefix);
                log.debug("Prefix mapping: " + prefix + " => " + altPrefix);
            }
            catch (JenaException ex) {
                log.warn("Error processing prefix mapping: " + ex.getMessage());
                throw ex;
            }
        }
        return locMap;
    }

    public static LocationMapper createLocationMapper(String configPath) {
        if (configPath == null || configPath.length() == 0) {
            log.warn("Null configuration");
            return null;
        }
        StreamManager smgr = new StreamManager();
        smgr.addLocator(new LocatorFile());
        smgr.addLocator(new LocatorClassLoader(smgr.getClass().getClassLoader()));
        try {
            String uri;
            String uriConfig = null;
            TypedInputStream in = null;
            StringTokenizer pathElems = new StringTokenizer(configPath, ";");
            while (pathElems.hasMoreTokens() && (uri = pathElems.nextToken()) != null && uri.length() != 0) {
                in = smgr.openNoMapOrNull(uri);
                if (in == null) continue;
                uriConfig = uri;
                break;
            }
            if (in == null) {
                log.debug("Failed to find configuration: " + configPath);
                return null;
            }
            Lang lang = RDFLanguages.resourceNameToLang(configPath);
            Model model = ModelFactory.createDefaultModel();
            RDFParser.source(in).lang(lang).parse(model);
            return JenaIOEnvironment.processConfig(model);
        }
        catch (JenaException ex) {
            LoggerFactory.getLogger(LocationMapper.class).warn("Error in configuration file: " + ex.getMessage());
            return new LocationMapper();
        }
    }
}

