/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.factories;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.ontapi.common.OntEnhGraph;
import org.apache.jena.ontapi.common.OntPersonality;
import org.apache.jena.ontapi.impl.OntGraphModelImpl;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.SWRL;

final class OntIndividuals {
    private static final String FORBIDDEN_SUBJECTS = OntIndividual.Anonymous.class.getName() + ".InSubject";
    private static final String FORBIDDEN_OBJECTS = OntIndividual.Anonymous.class.getName() + ".InObject";
    private static final Set<Node> FOR_SUBJECT = Stream.of(OWL2.sameAs, OWL2.differentFrom).map(FrontsNode::asNode).collect(Collectors.toUnmodifiableSet());
    private static final Set<Node> FOR_OBJECT = Stream.of(OWL2.sameAs, OWL2.differentFrom, OWL2.sourceIndividual, OWL2.targetIndividual, OWL2.hasValue, OWL2.annotatedSource, OWL2.annotatedTarget, RDF.first, SWRL.argument1, SWRL.argument2).map(FrontsNode::asNode).collect(Collectors.toUnmodifiableSet());

    OntIndividuals() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testAnonymousIndividual(Node node, EnhGraph eg) {
        if (!node.isBlank()) {
            return false;
        }
        boolean hasType = false;
        try (ExtendedIterator<Node> types = eg.asGraph().find(node, RDF.Nodes.type, Node.ANY).mapWith(Triple::getObject);){
            while (types.hasNext()) {
                if (OntEnhGraph.canAs(OntClass.class, (Node)types.next(), eg)) {
                    boolean bl = true;
                    return bl;
                }
                hasType = true;
            }
        }
        if (hasType) {
            return false;
        }
        Set<Node> forbiddenSubjects = OntIndividuals.reserved(eg, FORBIDDEN_SUBJECTS, FOR_SUBJECT);
        try (ExtendedIterator<Node> bySubject = eg.asGraph().find(node, Node.ANY, Node.ANY).mapWith(Triple::getPredicate);){
            while (bySubject.hasNext()) {
                if (!forbiddenSubjects.contains(bySubject.next())) continue;
                boolean bl = false;
                return bl;
            }
        }
        Set<Node> forbiddenObjects = OntIndividuals.reserved(eg, FORBIDDEN_OBJECTS, FOR_OBJECT);
        try (ExtendedIterator<Node> byObject = eg.asGraph().find(Node.ANY, Node.ANY, node).mapWith(Triple::getPredicate);){
            while (byObject.hasNext()) {
                if (!forbiddenObjects.contains(byObject.next())) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private static Set<Node> reserved(EnhGraph eg, String key, Set<Node> forbiddenProperties) {
        OntPersonality personality = OntEnhGraph.asPersonalityModel(eg).getOntPersonality();
        OntPersonality.Builtins builtins = personality.getBuiltins();
        OntPersonality.Reserved reserved = personality.getReserved();
        Set<Node> builtinProperties = builtins.getOntProperties();
        if (eg instanceof OntGraphModelImpl) {
            Map<String, Object> store = ((OntGraphModelImpl)eg).propertyStore;
            Object res = store.get(key);
            if (res != null) {
                return (Set)res;
            }
            Set<Node> forbidden = reserved.getProperties().stream().filter(n -> !builtinProperties.contains(n) && !forbiddenProperties.contains(n)).collect(Collectors.toUnmodifiableSet());
            store.put(key, forbidden);
            return forbidden;
        }
        return reserved.getProperties().stream().filter(n -> !builtinProperties.contains(n) && !forbiddenProperties.contains(n)).collect(Collectors.toUnmodifiableSet());
    }
}

