/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs;

import java.util.List;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.ui.Activator;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreTitleAreaDialog;
import org.eclipse.emf.emfstore.internal.client.ui.views.changes.TabbedChangesComposite;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateDialog
extends EMFStoreTitleAreaDialog {
    private final List<AbstractChangePackage> changes;
    private final ProjectSpace projectSpace;
    private Image updateImage;
    private final ModelElementIdToEObjectMapping idToEObjectMapping;
    private TabbedChangesComposite changesComposite;

    public UpdateDialog(Shell parentShell, ESLocalProject localProject, List<AbstractChangePackage> changes, ModelElementIdToEObjectMapping idToEObjectMapping) {
        super(parentShell);
        this.idToEObjectMapping = idToEObjectMapping;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.changes = changes;
        this.projectSpace = (ProjectSpace)((ESLocalProjectImpl)localProject).toInternalAPI();
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(4, 4, true, true));
        contents.setLayout((Layout)new GridLayout(1, false));
        if (this.changes != null) {
            this.changesComposite = new TabbedChangesComposite(contents, 2048, this.changes, this.projectSpace.getProject(), this.idToEObjectMapping, true);
            this.changesComposite.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        }
        String projectName = "";
        if (this.projectSpace.getProjectName() != null && this.projectSpace.getProjectName().length() > 0) {
            projectName = " for project \"" + this.projectSpace.getProjectName() + "\"";
        }
        this.setTitle("Incoming changes from server" + projectName);
        int operationCount = 0;
        int rootCount = 0;
        for (AbstractChangePackage changePackage : this.changes) {
            rootCount += changePackage.size();
            operationCount += changePackage.leafSize();
        }
        this.setMessage("Number of versions: " + this.changes.size() + ", Number of composite changes: " + rootCount + ", Number of overall changes: " + operationCount);
        return contents;
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Update");
        this.updateImage = Activator.getImageDescriptor("icons/arrow_up.png").createImage();
        newShell.setImage(this.updateImage);
    }

    public boolean close() {
        this.updateImage.dispose();
        this.changesComposite.dispose();
        return super.close();
    }

    protected void okPressed() {
        super.okPressed();
    }
}

