/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.Messages;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.DecisionUtil;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.SingleReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.UnkownFeatureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleReferenceConflict
extends VisualConflict {
    private static final String THEIRVALUE_KEY = "theirvalue";
    private static final String SINGLEREF_GIF = "singleref.gif";
    private static final String MYVALUE_KEY = "myvalue";
    private static final String SINGLE_REFERENCECONFLICT_SET_KEY = "singlereferenceconflict.set";
    private static final String SINGLE_REFERENCECONFLICT_MOVE_KEY = "singlereferenceconflict.move";

    public SingleReferenceConflict(ConflictBucket conflictBucket, DecisionManager decisionManager) {
        super(conflictBucket, decisionManager);
    }

    public SingleReferenceConflict(ConflictBucket conflictBucket, SingleReferenceOperation leftOperation, SingleReferenceOperation rightOperation, DecisionManager decisionManager) {
        super(conflictBucket, (AbstractOperation)leftOperation, (AbstractOperation)rightOperation, decisionManager, true, true);
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription description) {
        if (this.isContainmentFeature()) {
            description.setDescription(DecisionUtil.getDescription(SINGLE_REFERENCECONFLICT_MOVE_KEY, this.getDecisionManager().isBranchMerge()));
        } else {
            description.setDescription(DecisionUtil.getDescription(SINGLE_REFERENCECONFLICT_SET_KEY, this.getDecisionManager().isBranchMerge()));
        }
        EObject myNewValue = this.getDecisionManager().getModelElement(this.getMyOperation(SingleReferenceOperation.class).getNewValue());
        description.add(MYVALUE_KEY, myNewValue == null ? Messages.SingleReferenceConflict_Unset : myNewValue);
        EObject theirNewValue = this.getDecisionManager().getModelElement(this.getTheirOperation(SingleReferenceOperation.class).getNewValue());
        description.add(THEIRVALUE_KEY, theirNewValue == null ? "(unset)" : theirNewValue);
        description.setImage(SINGLEREF_GIF);
        return description;
    }

    private boolean isContainmentFeature() {
        EObject modelElement = this.getDecisionManager().getModelElement(this.getMyOperation().getModelElementId());
        if (modelElement == null) {
            return false;
        }
        try {
            if (((EReference)this.getMyOperation(SingleReferenceOperation.class).getFeature(modelElement)).isContainer()) {
                return true;
            }
        }
        catch (UnkownFeatureException unkownFeatureException) {}
        return false;
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        ModelElementId newValue = this.getMyOperation(SingleReferenceOperation.class).getNewValue();
        ConflictOption myOption = new ConflictOption(newValue == null ? Messages.SingleReferenceConflict_Unset : DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(newValue)), ConflictOption.OptionType.MyOperation);
        myOption.addOperations(this.getMyOperations());
        ModelElementId theirNewValue = this.getTheirOperation(SingleReferenceOperation.class).getNewValue();
        ConflictOption theirOption = new ConflictOption(DecisionUtil.getLabel(DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(theirNewValue)), Messages.SingleReferenceConflict_Unset), ConflictOption.OptionType.TheirOperation);
        theirOption.addOperations(this.getTheirOperations());
        options.add(myOption);
        options.add(theirOption);
    }
}

