/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.HasRolePredicate;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.Messages;
import org.eclipse.emf.emfstore.internal.server.core.MonitorProvider;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.SessionTimedOutException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.ProjectAdminRole;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.Role;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.ServerAdmin;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESGlobalProjectIdImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESGroupImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESProjectHistoryImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESUserImpl;
import org.eclipse.emf.emfstore.server.auth.ESAuthorizationService;
import org.eclipse.emf.emfstore.server.auth.ESMethod;
import org.eclipse.emf.emfstore.server.auth.ESMethodInvocation;
import org.eclipse.emf.emfstore.server.auth.ESOrgUnitResolver;
import org.eclipse.emf.emfstore.server.auth.ESProjectAdminPrivileges;
import org.eclipse.emf.emfstore.server.auth.ESSessions;
import org.eclipse.emf.emfstore.server.model.ESGlobalProjectId;
import org.eclipse.emf.emfstore.server.model.ESGroup;
import org.eclipse.emf.emfstore.server.model.ESOrgUnit;
import org.eclipse.emf.emfstore.server.model.ESOrgUnitId;
import org.eclipse.emf.emfstore.server.model.ESOrgUnitProvider;
import org.eclipse.emf.emfstore.server.model.ESProjectHistory;
import org.eclipse.emf.emfstore.server.model.ESSessionId;
import org.eclipse.emf.emfstore.server.model.ESUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultESAuthorizationService
implements ESAuthorizationService {
    private EnumMap<ESMethod.MethodId, AccessLevel> accessMap;
    private ESSessions sessions;
    private ESOrgUnitResolver orgUnitResolver;
    private ESOrgUnitProvider orgUnitProvider;
    private final Predicate<Role> isServerAdminPredicate = new HasRolePredicate(ServerAdmin.class);
    private final Predicate<Role> isProjectAdminPredicate = new HasRolePredicate(ProjectAdminRole.class);

    private void initAccessMap() {
        if (this.accessMap != null) {
            return;
        }
        this.accessMap = new EnumMap(ESMethod.MethodId.class);
        this.addAccessMapping(AccessLevel.NONE, ESMethod.MethodId.GETVERSION);
        this.addAccessMapping(AccessLevel.PROJECT_READ, ESMethod.MethodId.GETPROJECT, ESMethod.MethodId.GETEMFPROPERTIES, ESMethod.MethodId.GETHISTORYINFO, ESMethod.MethodId.GETCHANGES, ESMethod.MethodId.RESOLVEVERSIONSPEC, ESMethod.MethodId.DOWNLOADFILECHUNK, ESMethod.MethodId.DOWNLOADCHANGEPACKAGEFRAGMENT);
        this.addAccessMapping(AccessLevel.PROJECT_WRITE, ESMethod.MethodId.SETEMFPROPERTIES, ESMethod.MethodId.TRANSMITPROPERTY, ESMethod.MethodId.UPLOADFILECHUNK, ESMethod.MethodId.CREATEVERSION, ESMethod.MethodId.UPLOADCHANGEPACKAGEFRAGMENT, ESMethod.MethodId.GETBRANCHES);
        this.addAccessMapping(AccessLevel.PROJECT_ADMIN, ESMethod.MethodId.DELETEPROJECT, ESMethod.MethodId.REMOVETAG, ESMethod.MethodId.ADDTAG);
        this.addAccessMapping(AccessLevel.SERVER_ADMIN, ESMethod.MethodId.IMPORTPROJECTHISTORYTOSERVER, ESMethod.MethodId.EXPORTPROJECTHISTORYFROMSERVER, ESMethod.MethodId.REGISTEREPACKAGE);
        if (ServerConfiguration.isProjectAdminPrivileg(ESProjectAdminPrivileges.ShareProject)) {
            this.addAccessMapping(AccessLevel.PROJECT_ADMIN, ESMethod.MethodId.CREATEPROJECT, ESMethod.MethodId.CREATEEMPTYPROJECT);
        } else {
            this.addAccessMapping(AccessLevel.SERVER_ADMIN, ESMethod.MethodId.CREATEPROJECT, ESMethod.MethodId.CREATEEMPTYPROJECT);
        }
        this.addAccessMapping(AccessLevel.NONE, ESMethod.MethodId.GETPROJECTLIST, ESMethod.MethodId.RESOLVEUSER);
    }

    private void addAccessMapping(AccessLevel type, ESMethod.MethodId ... operationTypes) {
        ESMethod.MethodId[] methodIdArray = operationTypes;
        int n = operationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ESMethod.MethodId opType = methodIdArray[n2];
            this.accessMap.put(opType, type);
            ++n2;
        }
    }

    @Override
    public boolean checkProjectAdminAccess(ESSessionId sessionId, ESGlobalProjectId globalProjectId) throws AccessControlException {
        this.checkSession(sessionId);
        ACUser user = (ACUser)this.getOrgUnit(this.sessions.resolveToOrgUnitId(sessionId));
        List<Role> roles = this.getAllRoles((ESOrgUnitId)user.getId().toAPI());
        if (Iterables.any(roles, this.isServerAdminPredicate)) {
            return true;
        }
        ProjectId projectId = (ProjectId)APIUtil.toInternal(ProjectId.class, (Object)globalProjectId);
        for (Role role : roles) {
            if (projectId == null && ProjectAdminRole.class.isInstance(role)) {
                return false;
            }
            if (!role.canAdministrate(projectId)) continue;
            return false;
        }
        throw new AccessControlException(Messages.AccessControlImpl_Insufficient_Rights);
    }

    @Override
    public void checkServerAdminAccess(ESSessionId sessionId) throws AccessControlException {
        this.checkSession(sessionId);
        ACUser user = (ACUser)this.getOrgUnit(this.sessions.resolveToOrgUnitId(sessionId));
        List rolesFromGroups = APIUtil.toInternal(this.orgUnitResolver.getRolesFromGroups((ESOrgUnit)user.toAPI()));
        Iterable roles = Iterables.concat((Iterable)user.getRoles(), (Iterable)rolesFromGroups);
        if (Iterables.any((Iterable)roles, this.isServerAdminPredicate)) {
            return;
        }
        throw new AccessControlException(Messages.AccessControlImpl_Insufficient_Rights);
    }

    @Override
    public boolean checkProjectAdminAccessForOrgUnit(ESSessionId sessionId, ESOrgUnitId orgUnitId) throws AccessControlException {
        this.checkSession(sessionId);
        this.cleanupPARole(orgUnitId);
        List<Role> allRoles = this.getAllRoles(orgUnitId);
        LinkedHashSet involvedProjects = new LinkedHashSet();
        ACUser user = (ACUser)this.getOrgUnit(this.sessions.resolveToOrgUnitId(sessionId));
        boolean hasServerAdminRole = Iterables.any((Iterable)user.getRoles(), this.isServerAdminPredicate);
        for (Role role : allRoles) {
            if ((this.isServerAdminPredicate.apply((Object)role) || this.isProjectAdminPredicate.apply((Object)role)) && !hasServerAdminRole) {
                throw new AccessControlException(Messages.AccessControlImpl_Not_Allowed_To_Remove_Other_Admin);
            }
            involvedProjects.addAll(role.getProjects());
        }
        LinkedHashSet<ESGlobalProjectId> globalIds = new LinkedHashSet<ESGlobalProjectId>();
        for (ProjectId projectId : involvedProjects) {
            globalIds.add((ESGlobalProjectId)projectId.toAPI());
        }
        return this.checkProjectAdminAccessForOrgUnit(sessionId, orgUnitId, globalIds);
    }

    @Override
    public boolean checkProjectAdminAccessForOrgUnit(ESSessionId sessionId, ESOrgUnitId orgUnitId, Set<ESGlobalProjectId> projectIds) throws AccessControlException {
        this.checkSession(sessionId);
        this.cleanupPARole(orgUnitId);
        ACUser user = (ACUser)this.getOrgUnit(this.sessions.resolveToOrgUnitId(sessionId));
        List<Role> allRoles = this.getAllRoles((ESOrgUnitId)user.getId().toAPI());
        if (Iterables.any(allRoles, this.isServerAdminPredicate)) {
            return true;
        }
        try {
            ProjectAdminRole projectAdminRole = (ProjectAdminRole)Iterables.find((Iterable)user.getRoles(), this.isProjectAdminPredicate);
            LinkedHashSet<ProjectId> ids = new LinkedHashSet<ProjectId>();
            for (ESGlobalProjectId projectId : projectIds) {
                ids.add((ProjectId)APIUtil.toInternal(ProjectId.class, (Object)projectId));
            }
            if (projectAdminRole.getProjects().containsAll(ids)) {
                return false;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new AccessControlException(Messages.AccessControlImpl_Insufficient_Rights);
        }
        throw new AccessControlException(Messages.AccessControlImpl_Insufficient_Rights);
    }

    @Override
    public boolean checkProjectAdminAccess(ESSessionId sessionId, ESGlobalProjectId globalProjectId, ESProjectAdminPrivileges privileg) throws AccessControlException {
        this.checkSession(sessionId);
        ACUser user = (ACUser)this.getOrgUnit(this.sessions.resolveToOrgUnitId(sessionId));
        List<Role> roles = this.getAllRoles((ESOrgUnitId)user.getId().toAPI());
        if (Iterables.any(roles, this.isServerAdminPredicate)) {
            return true;
        }
        for (Role role : roles) {
            ProjectId projectId;
            if (!ProjectAdminRole.class.isInstance(role)) continue;
            if (!ServerConfiguration.isProjectAdminPrivileg(privileg)) {
                throw new AccessControlException(Messages.AccessControlImpl_PARole_Missing_Privilege);
            }
            if (globalProjectId == null) {
                return false;
            }
            ProjectAdminRole projectAdminRole = (ProjectAdminRole)ProjectAdminRole.class.cast(role);
            if (!projectAdminRole.canAdministrate(projectId = (ProjectId)APIUtil.toInternal(ProjectId.class, (Object)globalProjectId))) {
                throw new AccessControlException(Messages.AccessControlImpl_PARole_Missing_Privilege);
            }
            return false;
        }
        throw new AccessControlException(Messages.AccessControlImpl_Insufficient_Rights);
    }

    @Override
    public void checkReadAccess(ESSessionId sessionId, ESGlobalProjectId globalProjectId, Set<EObject> modelElements) throws AccessControlException {
        this.checkSession(sessionId);
        ACUser user = (ACUser)this.getOrgUnit(this.sessions.resolveToOrgUnitId(sessionId));
        List internalRoles = APIUtil.toInternal(this.orgUnitResolver.getRolesFromGroups((ESOrgUnit)user.toAPI()));
        Iterable roles = Iterables.concat((Iterable)user.getRoles(), (Iterable)internalRoles);
        ProjectId internalAPI = (ProjectId)APIUtil.toInternal(ProjectId.class, (Object)globalProjectId);
        if (!this.canRead(roles, internalAPI, null)) {
            throw new AccessControlException(Messages.AccessControlImpl_Insufficient_Rights);
        }
    }

    private boolean canWrite(Iterable<Role> roles, ProjectId projectId, EObject modelElement) {
        for (Role role : roles) {
            if (!role.canModify(projectId, modelElement) && !role.canCreate(projectId, modelElement) && !role.canDelete(projectId, modelElement)) continue;
            return true;
        }
        return false;
    }

    private boolean canRead(Iterable<Role> roles, ProjectId projectId, EObject modelElement) throws AccessControlException {
        for (Role role : roles) {
            if (!role.canRead(projectId, modelElement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkWriteAccess(ESSessionId sessionId, ESGlobalProjectId globalProjectId, Set<EObject> modelElements) throws AccessControlException {
        this.checkSession(sessionId);
        ACUser user = (ACUser)this.getOrgUnit(this.sessions.resolveToOrgUnitId(sessionId));
        List internalRoles = APIUtil.toInternal(this.orgUnitResolver.getRolesFromGroups((ESOrgUnit)user.toAPI()));
        Iterable roles = Iterables.concat((Iterable)user.getRoles(), (Iterable)internalRoles);
        ProjectId projectId = (ProjectId)APIUtil.toInternal(ProjectId.class, (Object)globalProjectId);
        if (!this.canWrite(roles, projectId, null)) {
            throw new AccessControlException(Messages.AccessControlImpl_Insufficient_Rights);
        }
    }

    @Override
    public void checkAccess(ESMethodInvocation op) throws AccessControlException {
        this.initAccessMap();
        AccessLevel accessType = this.accessMap.get((Object)op.getType());
        if (accessType == null) {
            throw new AccessControlException(Messages.AccessControlImpl_No_Access);
        }
        switch (accessType) {
            case PROJECT_READ: {
                ProjectId projectId = this.getProjectIdFromParameters(op);
                this.checkReadAccess(op.getSessionId(), (ESGlobalProjectId)(projectId == null ? null : (ESGlobalProjectIdImpl)projectId.toAPI()), null);
                break;
            }
            case PROJECT_WRITE: {
                ProjectId projectId = this.getProjectIdFromParameters(op);
                this.checkWriteAccess(op.getSessionId(), (ESGlobalProjectId)(projectId == null ? null : (ESGlobalProjectIdImpl)projectId.toAPI()), null);
                break;
            }
            case PROJECT_ADMIN: {
                ProjectId projectId = this.getProjectIdFromParameters(op);
                this.checkProjectAdminAccess(op.getSessionId(), (ESGlobalProjectId)(projectId == null ? null : (ESGlobalProjectIdImpl)projectId.toAPI()));
                break;
            }
            case SERVER_ADMIN: {
                this.checkServerAdminAccess(op.getSessionId());
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new AccessControlException(Messages.AccessControlImpl_Unknown_Access_Type);
            }
        }
    }

    private ProjectId getProjectIdFromParameters(ESMethodInvocation op) {
        Object[] objectArray = op.getParameters();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof ProjectId) {
                return (ProjectId)obj;
            }
            ++n2;
        }
        return null;
    }

    private void cleanupPARole(ESOrgUnitId esOrgUnitId) throws AccessControlException {
        ProjectAdminRole paRole = null;
        List<Role> roles = this.getAllRoles(esOrgUnitId);
        for (Role role : roles) {
            if (!ProjectAdminRole.class.isInstance(role)) continue;
            paRole = (ProjectAdminRole)role;
            break;
        }
        if (paRole == null) {
            return;
        }
        List externalProjects = this.orgUnitProvider.getProjects();
        ArrayList<ProjectHistory> projects = new ArrayList<ProjectHistory>();
        for (ESProjectHistory projectHistory : externalProjects) {
            projects.add((ProjectHistory)((ESProjectHistoryImpl)ESProjectHistoryImpl.class.cast(projectHistory)).toInternalAPI());
        }
        LinkedHashSet<ProjectId> validProjectIds = new LinkedHashSet<ProjectId>();
        LinkedHashSet<ProjectId> invalidProjectIdsOfRole = new LinkedHashSet<ProjectId>();
        for (ProjectHistory projectHistory : projects) {
            validProjectIds.add(projectHistory.getProjectId());
        }
        for (ProjectId projectId : paRole.getProjects()) {
            if (validProjectIds.contains(projectId)) continue;
            invalidProjectIdsOfRole.add(projectId);
        }
        paRole.getProjects().removeAll(invalidProjectIdsOfRole);
        if (paRole.getProjects().size() == 0) {
            this.getOrgUnit(esOrgUnitId).getRoles().remove((Object)paRole);
        }
    }

    private List<Role> getAllRoles(ESOrgUnitId orgUnitId) throws AccessControlException {
        ACOrgUnit<?> internalOrgUnit = this.getOrgUnit(orgUnitId);
        ESOrgUnit orgUnit = (ESOrgUnit)internalOrgUnit.toAPI();
        List groups = APIUtil.toInternal(this.orgUnitResolver.getGroups(orgUnit));
        ArrayList<Role> roles = new ArrayList<Role>();
        for (ACGroup group : groups) {
            roles.addAll((Collection<Role>)group.getRoles());
        }
        roles.addAll((Collection<Role>)internalOrgUnit.getRoles());
        return roles;
    }

    private ACOrgUnit<?> getOrgUnit(ESOrgUnitId orgUnitId) throws AccessControlException {
        Preconditions.checkNotNull((Object)orgUnitId, (Object)"orgUnitId must not be null");
        ACOrgUnitId internalId = (ACOrgUnitId)APIUtil.toInternal(ACOrgUnitId.class, (Object)orgUnitId);
        Object object = MonitorProvider.getInstance().getMonitor();
        synchronized (object) {
            ACUser internalAPI;
            for (ESUser user : this.orgUnitProvider.getUsers()) {
                internalAPI = (ACUser)((ESUserImpl)ESUserImpl.class.cast(user)).toInternalAPI();
                if (!internalAPI.getId().equals(internalId)) continue;
                return internalAPI;
            }
            for (ESGroup group : this.orgUnitProvider.getGroups()) {
                internalAPI = (ACGroup)((ESGroupImpl)ESGroupImpl.class.cast(group)).toInternalAPI();
                if (!internalAPI.getId().equals(internalId)) continue;
                return internalAPI;
            }
            throw new AccessControlException(Messages.AccessControlImpl_Given_OrgUnit_Does_Not_Exist);
        }
    }

    @Override
    public void init(ESSessions sessions, ESOrgUnitResolver orgUnitResolverServive, ESOrgUnitProvider orgUnitProvider) {
        this.sessions = sessions;
        this.orgUnitResolver = orgUnitResolverServive;
        this.orgUnitProvider = orgUnitProvider;
    }

    private void checkSession(ESSessionId sessionId) throws SessionTimedOutException {
        this.sessions.isValid(sessionId);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AccessLevel {
        PROJECT_READ,
        PROJECT_WRITE,
        PROJECT_ADMIN,
        SERVER_ADMIN,
        NONE;

    }
}

