/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.filetransfer;

import java.io.File;
import java.io.IOException;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.server.exceptions.FileTransferException;
import org.eclipse.emf.emfstore.internal.server.model.FileIdentifier;

public class FileTransferCacheManager {
    public static final String TEMP_FOLDER = "tmp";
    public static final String PROJECT_FOLDER_PREFIX = "project-";
    public static final String ATTACHMENT_FOLDER = "attachment";
    public static final String FILE_NAME_DELIMITER = "_";
    private final ProjectSpace projectSpace;
    private final File cacheFolder;
    private final File tempCacheFolder;

    public FileTransferCacheManager(ProjectSpace projectSpaceImpl) {
        this.projectSpace = projectSpaceImpl;
        this.cacheFolder = new File(FileTransferCacheManager.getCacheFolder(this.projectSpace));
        this.tempCacheFolder = new File(this.cacheFolder, "temp");
        this.mkdirs();
    }

    public static String getCacheFolder(ProjectSpace projectSpace) {
        return String.valueOf(Configuration.getFileInfo().getWorkspaceDirectory()) + "ps-" + projectSpace.getIdentifier() + File.separatorChar + "files" + File.separatorChar;
    }

    public boolean hasCachedFile(FileIdentifier identifier) {
        File f = this.getFileFromId(this.cacheFolder, identifier);
        return f.exists();
    }

    public File getCachedFile(FileIdentifier identifier) throws FileTransferException {
        File f = this.getFileFromId(this.cacheFolder, identifier);
        if (!f.exists()) {
            throw new FileTransferException("The file with the id " + identifier + " is not in the cache");
        }
        return f;
    }

    public File cacheFile(File input, FileIdentifier id) throws IOException {
        this.mkdirs();
        File destination = new File(this.cacheFolder, id.getIdentifier());
        FileUtil.copyFile((File)input, (File)destination);
        return destination;
    }

    public File createTempFile(FileIdentifier id) throws FileTransferException {
        this.mkdirs();
        File cacheFile = this.getFileFromId(this.tempCacheFolder, id);
        if (cacheFile.exists()) {
            cacheFile.delete();
        }
        try {
            cacheFile.createNewFile();
        }
        catch (IOException iOException) {
            throw new FileTransferException("Could not create temporary file");
        }
        return cacheFile;
    }

    public File moveTempFileToCache(FileIdentifier id) throws FileTransferException {
        this.mkdirs();
        File cacheFile = this.getFileFromId(this.cacheFolder, id);
        File tmpFile = this.getFileFromId(this.tempCacheFolder, id);
        if (!tmpFile.exists()) {
            throw new FileTransferException("Could not move temp file to cache folder. The file does not exist in the temp folder. FileId: " + id.getIdentifier());
        }
        if (cacheFile.exists()) {
            throw new FileTransferException("Could not move temp file to cache folder. The file already exists in the cache folder" + id.getIdentifier());
        }
        if (!tmpFile.renameTo(cacheFile)) {
            throw new FileTransferException("Could not move temp file to cache folder. The move operation failed");
        }
        return cacheFile;
    }

    private File getFileFromId(File folder, FileIdentifier id) {
        return new File(folder, id.getIdentifier());
    }

    private void mkdirs() {
        this.cacheFolder.mkdirs();
        this.tempCacheFolder.mkdirs();
    }

    public boolean removeCachedFile(FileIdentifier fileIdentifier) {
        File toRemove = this.getFileFromId(this.cacheFolder, fileIdentifier);
        if (toRemove.exists()) {
            return toRemove.delete();
        }
        return false;
    }
}

