/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.factory;

import java.util.Properties;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.AuthenticationControlType;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.factory.AuthenticationControlFactory;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers.AbstractAuthenticationControl;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers.EMFModelAuthenticationVerifier;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers.LDAPVerifier;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers.SimplePropertyFileVerifier;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers.VerifierChain;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidPropertyException;

public final class AuthenticationControlFactoryImpl
implements AuthenticationControlFactory {
    private static AuthenticationControlFactory instance = new AuthenticationControlFactoryImpl();

    private AuthenticationControlFactoryImpl() {
    }

    public static AuthenticationControlFactory getInstance() {
        return instance;
    }

    public AbstractAuthenticationControl createAuthenticationControl(AuthenticationControlType authenticationControlType) throws FatalESException {
        if (authenticationControlType.equals((Object)AuthenticationControlType.ldap)) {
            VerifierChain chain = new VerifierChain();
            Properties properties = ServerConfiguration.getProperties();
            int count = 1;
            while (count != -1) {
                String ldapUrl = properties.getProperty("emfstore.accesscontrol.authentication.ldap." + count + "." + "url");
                String ldapBase = properties.getProperty("emfstore.accesscontrol.authentication.ldap." + count + "." + "base");
                String searchDn = properties.getProperty("emfstore.accesscontrol.authentication.ldap." + count + "." + "searchdn");
                String authUser = properties.getProperty("emfstore.accesscontrol.authentication.ldap." + count + "." + "authuser");
                String authPassword = properties.getProperty("emfstore.accesscontrol.authentication.ldap." + count + "." + "authpass");
                if (ldapUrl != null && ldapBase != null && searchDn != null) {
                    LDAPVerifier ldapVerifier = new LDAPVerifier(ldapUrl, ldapBase, searchDn, authUser, authPassword);
                    chain.getVerifiers().add(ldapVerifier);
                    ++count;
                    continue;
                }
                count = -1;
            }
            return chain;
        }
        if (authenticationControlType.equals((Object)AuthenticationControlType.spfv)) {
            return new SimplePropertyFileVerifier(ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.spfv", ServerConfiguration.getDefaultSPFVFilePath()));
        }
        if (authenticationControlType.equals((Object)AuthenticationControlType.model)) {
            return new EMFModelAuthenticationVerifier();
        }
        throw new InvalidPropertyException();
    }
}

