/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.connectionmanager.xmlrpc;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcSun15HttpTransportFactory;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.XmlRpcController;
import org.eclipse.emf.emfstore.client.exceptions.ESCertificateException;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.KeyStoreManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.xmlrpc.Messages;
import org.eclipse.emf.emfstore.internal.common.model.util.SerializationException;
import org.eclipse.emf.emfstore.internal.server.connection.xmlrpc.util.EObjectTypeFactory;
import org.eclipse.emf.emfstore.internal.server.exceptions.ConnectionException;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlRpcClientManager {
    private final String serverInterface;
    private XmlRpcClient client;
    private static boolean serializationOptionsInitialized;
    private static boolean gzipCompressionEnabled;
    private static boolean gzipRequestingEnabled;

    public XmlRpcClientManager(String serverInterface) {
        this.serverInterface = serverInterface;
    }

    public void initConnection(ServerInfo serverInfo) throws ConnectionException {
        try {
            XmlRpcClientManager.initSerializationOptions();
            XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
            config.setServerURL(this.createURL(serverInfo));
            config.setEnabledForExceptions(true);
            config.setEnabledForExtensions(true);
            config.setConnectionTimeout(Configuration.getXMLRPC().getXMLRPCConnectionTimeout());
            config.setReplyTimeout(Configuration.getXMLRPC().getXMLRPCReplyTimeout());
            config.setContentLengthOptional(true);
            config.setGzipCompressing(gzipCompressionEnabled);
            config.setGzipRequesting(gzipRequestingEnabled);
            this.client = new XmlRpcClient();
            this.client.setTypeFactory((TypeFactory)new EObjectTypeFactory((XmlRpcController)this.client));
            XmlRpcSun15HttpTransportFactory factory = new XmlRpcSun15HttpTransportFactory(this.client);
            try {
                factory.setSSLSocketFactory(KeyStoreManager.getInstance().getSSLContext().getSocketFactory());
            }
            catch (ESCertificateException e) {
                throw new ConnectionException(Messages.XmlRpcClientManager_Could_Not_Load_Certificate, (Throwable)e);
            }
            this.client.setTransportFactory((XmlRpcTransportFactory)factory);
            this.client.setConfig((XmlRpcClientConfig)config);
        }
        catch (MalformedURLException e) {
            throw new ConnectionException(Messages.XmlRpcClientManager_Malformed_URL_Or_Port, (Throwable)e);
        }
    }

    private URL createURL(ServerInfo serverInfo) throws MalformedURLException {
        this.checkUrl(serverInfo.getUrl());
        return new URL("https", serverInfo.getUrl(), serverInfo.getPort(), "/xmlrpc");
    }

    private void checkUrl(String url) throws MalformedURLException {
        if (!(url == null || url.equals("") || url.contains(":") || url.contains("/"))) {
            return;
        }
        throw new MalformedURLException();
    }

    public <T> T callWithResult(String methodName, Class<T> returnType, Object ... parameters) throws ESException {
        return this.executeCall(methodName, returnType, parameters);
    }

    public <T> List<T> callWithListResult(String methodName, Class<T> returnType, Object ... parameters) throws ESException {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] callResult = this.executeCall(methodName, Object[].class, parameters);
        if (callResult == null) {
            return result;
        }
        Object[] objectArray = callResult;
        int n = callResult.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            result.add(obj);
            ++n2;
        }
        return result;
    }

    public void call(String methodName, Object ... parameters) throws ESException {
        this.executeCall(methodName, null, parameters);
    }

    private <T> T executeCall(String methodName, Class<T> returnType, Object[] params) throws ESException {
        if (this.client == null) {
            throw new ConnectionException(ConnectionManager.REMOTE);
        }
        try {
            return (T)this.client.execute(String.valueOf(this.serverInterface) + "." + methodName, params);
        }
        catch (XmlRpcException e) {
            if (e.getCause() instanceof ESException) {
                throw (ESException)e.getCause();
            }
            if (e.linkedException instanceof SAXException && ((SAXException)e.linkedException).getException() instanceof SerializationException) {
                SerializationException serialE = (SerializationException)((Object)((SAXException)e.linkedException).getException());
                throw new org.eclipse.emf.emfstore.internal.server.exceptions.SerializationException((Throwable)serialE);
            }
            throw new ConnectionException(String.valueOf(ConnectionManager.REMOTE) + e.getMessage(), (Throwable)e);
        }
    }

    private static void initSerializationOptions() {
        if (serializationOptionsInitialized) {
            return;
        }
        gzipRequestingEnabled = false;
        gzipCompressionEnabled = false;
        ESExtensionElement element = new ESExtensionPoint("org.eclipse.emf.emfstore.common.model.serializationOptions").getFirst();
        if (element != null) {
            gzipCompressionEnabled = element.getBoolean("GzipCompression");
            gzipRequestingEnabled = element.getBoolean("GzipRequesting");
        }
        serializationOptionsInitialized = true;
    }
}

