/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.provider;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;

public abstract class ESAbstractClientURIConverter
extends ExtensibleURIConverterImpl {
    public URI normalize(URI uri) {
        if (uri.scheme() != null && uri.scheme().equals("emfstore") && uri.authority().equals("workspaces")) {
            if (uri.segment(1).equals("workspace")) {
                return this.normalizeWorkspaceURI(uri.segment(0));
            }
            if (uri.segment(1).equals("projectspaces")) {
                return this.normalizeProjectSpaces(uri);
            }
        }
        return super.normalize(uri);
    }

    private URI normalizeProjectSpaces(URI uri) {
        if (uri.segment(3).equals("project")) {
            return this.normalizeProjectURI(uri.segment(0), uri.segment(2));
        }
        if (uri.segment(3).equals("operations")) {
            return this.normalizeOperationsURI(uri.segment(0), uri.segment(2));
        }
        if (uri.segment(3).equals("projectspace")) {
            return this.normalizeProjectSpaceURI(uri.segment(0), uri.segment(2));
        }
        return super.normalize(uri);
    }

    protected abstract URI normalizeWorkspaceURI(String var1);

    protected abstract URI normalizeProjectURI(String var1, String var2);

    protected abstract URI normalizeOperationsURI(String var1, String var2);

    protected abstract URI normalizeProjectSpaceURI(String var1, String var2);
}

