/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging;

import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.ConflictResolver;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ChangeConflictSet;

public abstract class AbstractConflictResolver
implements ConflictResolver {
    private final boolean isBranchMerge;

    public AbstractConflictResolver(boolean isBranchMerge) {
        this.isBranchMerge = isBranchMerge;
    }

    public boolean resolveConflicts(Project project, ChangeConflictSet changeConflict) {
        this.preDecisionManagerHook();
        DecisionManager decisionManager = new DecisionManager(project, changeConflict, this.isBranchMerge);
        if (decisionManager.isResolved()) {
            this.setResults(decisionManager);
            return true;
        }
        boolean resolved = this.controlDecisionManager(decisionManager, changeConflict);
        if (resolved) {
            if (!decisionManager.isResolved()) {
                return false;
            }
            this.setResults(decisionManager);
        }
        this.postDecisionManagerHook();
        return resolved;
    }

    private void setResults(DecisionManager decisionManager) {
        decisionManager.calcResult();
    }

    protected void preDecisionManagerHook() {
    }

    protected void postDecisionManagerHook() {
    }

    protected abstract boolean controlDecisionManager(DecisionManager var1, ChangeConflictSet var2);
}

