/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecp.common.spi.EMFUtils;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.ECPProjectManager;
import org.eclipse.emf.ecp.core.ECPProviderRegistry;
import org.eclipse.emf.ecp.core.ECPRepositoryManager;
import org.eclipse.emf.ecp.core.util.ECPContainer;
import org.eclipse.emf.ecp.core.util.ECPElement;
import org.eclipse.emf.ecp.core.util.ECPModelContextProvider;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.core.util.observer.ECPObserverBus;
import org.eclipse.emf.ecp.internal.core.Activator;
import org.eclipse.emf.ecp.internal.core.util.ElementDescriptor;
import org.eclipse.emf.ecp.internal.core.util.Properties;
import org.eclipse.emf.ecp.spi.core.util.ECPDisposable;

public final class ECPUtil {
    private ECPUtil() {
    }

    public static ECPContainer getModelContext(ECPModelContextProvider contextProvider, Object ... elements) {
        ECPContainer commonContext = null;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            ECPContainer elementContext = contextProvider.getModelContext(element);
            if (elementContext == null) {
                return null;
            }
            if (elementContext != commonContext) {
                if (commonContext == null) {
                    commonContext = elementContext;
                } else {
                    return null;
                }
            }
            ++n2;
        }
        return commonContext;
    }

    public static ECPProperties createProperties() {
        return new Properties();
    }

    public static boolean isDisposed(Object object) {
        if (object instanceof ECPDisposable) {
            ECPDisposable disposable = (ECPDisposable)object;
            return disposable.isDisposed();
        }
        return false;
    }

    public static boolean isClosed(Object object) {
        if (object instanceof ECPProject) {
            ECPProject closeable = (ECPProject)object;
            return !closeable.isOpen();
        }
        return false;
    }

    public static ECPElement getResolvedElement(ECPElement elementOrDescriptor) {
        if (elementOrDescriptor instanceof ElementDescriptor) {
            ElementDescriptor descriptor = (ElementDescriptor)elementOrDescriptor;
            return descriptor.getResolvedElement();
        }
        return elementOrDescriptor;
    }

    public static Collection<EClass> getSubClasses(EClass superClass) {
        HashSet<EClass> classes = new HashSet<EClass>();
        ArrayList keySet = new ArrayList(EPackage.Registry.INSTANCE.keySet());
        for (String nsURI : keySet) {
            EPackage ePackage;
            try {
                ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
            }
            catch (Exception exception) {
                continue;
            }
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || !superClass.isSuperTypeOf(eClass = (EClass)eClassifier) || eClass.isAbstract() || eClass.isInterface()) continue;
                classes.add(eClass);
            }
        }
        return classes;
    }

    public static Set<EPackage> getAllRegisteredEPackages() {
        return EMFUtils.getAllRegisteredEPackages();
    }

    public static ECPProjectManager getECPProjectManager() {
        ECPProjectManager ecpProjectManagerInstance = Activator.getECPProjectManager();
        return ecpProjectManagerInstance;
    }

    public static ECPRepositoryManager getECPRepositoryManager() {
        ECPRepositoryManager epm = Activator.getECPRepositoryManager();
        return epm;
    }

    public static ECPProviderRegistry getECPProviderRegistry() {
        ECPProviderRegistry ecpProviderRegistryInstance = Activator.getECPProviderRegistry();
        return ecpProviderRegistryInstance;
    }

    public static ECPObserverBus getECPObserverBus() {
        return Activator.getECPObserverBus();
    }
}

