/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.cdo.internal.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Set;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.session.CDOSessionConfigurationFactory;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.workspace.CDOWorkspaceBase;
import org.eclipse.emf.cdo.workspace.CDOWorkspaceConfiguration;
import org.eclipse.emf.cdo.workspace.CDOWorkspaceUtil;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.cdo.internal.core.Activator;
import org.eclipse.emf.ecp.cdo.internal.core.CDOBranchWrapper;
import org.eclipse.emf.ecp.cdo.internal.core.CDOProjectData;
import org.eclipse.emf.ecp.cdo.internal.core.CDORepositoryData;
import org.eclipse.emf.ecp.cdo.internal.core.ECPProjectAdapterFactory;
import org.eclipse.emf.ecp.core.util.ECPContainer;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.spi.core.DefaultProvider;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.ecp.spi.core.InternalProvider;
import org.eclipse.emf.ecp.spi.core.InternalRepository;
import org.eclipse.emf.ecp.spi.core.util.InternalChildrenList;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.h2.H2Adapter;
import org.eclipse.net4j.util.UUIDGenerator;
import org.eclipse.net4j.util.collection.Closeable;
import org.eclipse.net4j.util.io.IOUtil;
import org.h2.jdbcx.JdbcDataSource;

public class CDOProvider
extends DefaultProvider {
    public static final String NAME = "org.eclipse.emf.ecp.cdo.provider";
    public static final String PROP_CONNECTOR_TYPE = "connectorType";
    public static final String PROP_CONNECTOR_DESCRIPTION = "connectorDescription";
    public static final String PROP_REPOSITORY_NAME = "repositoryName";
    public static final String PROP_BRANCH_PATH = "branchPath";
    public static final String PROP_TIME_STAMP = "timeStamp";
    public static final String PROP_WORKSPACE_ID = "workspaceID";
    private static CDOProvider instance;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$emf$ecp$spi$core$InternalProvider$LifecycleEvent;

    public CDOProvider() {
        super(NAME);
        instance = this;
        CDOUtil.setLegacyModeDefault((boolean)true);
    }

    @Deprecated
    public static CDOProvider getInstance() {
        return instance;
    }

    protected void doDispose() {
        instance = null;
        super.doDispose();
    }

    public <T> T getAdapter(Object adaptable, Class<T> adapterType) {
        T adapter = ECPProjectAdapterFactory.adapt(adaptable, adapterType);
        if (adapter != null) {
            return adapter;
        }
        return (T)super.getAdapter(adaptable, adapterType);
    }

    public boolean isSlow(Object parent) {
        if (parent instanceof CDOBranchWrapper) {
            return true;
        }
        if (parent instanceof EObject) {
            return true;
        }
        return super.isSlow(parent);
    }

    public void fillChildren(ECPContainer context, Object parent, InternalChildrenList childrenList) {
        if (parent instanceof InternalProject) {
            InternalProject project = (InternalProject)parent;
            CDOProjectData projectData = CDOProvider.getProjectData(project);
            childrenList.addChildren((Collection)projectData.getRootResource().getContents());
        } else if (parent instanceof InternalRepository) {
            InternalRepository repository = (InternalRepository)parent;
            CDOBranchWrapper wrapper = new CDOBranchWrapper(repository, "MAIN");
            childrenList.addChild((Object)wrapper);
        } else if (parent instanceof CDOBranchWrapper) {
            CDOBranchWrapper parentWrapper = (CDOBranchWrapper)parent;
            InternalRepository repository = parentWrapper.getRepository();
            String branchPath = parentWrapper.getBranchPath();
            CDONet4jSession session = null;
            try {
                CDORepositoryData repositoryData = CDOProvider.getRepositoryData(repository);
                CDONet4jSessionConfiguration sessionConfiguration = repositoryData.createSessionConfiguration();
                session = sessionConfiguration.openNet4jSession();
                CDOBranch branch = session.getBranchManager().getBranch(branchPath);
                CDOBranch[] cDOBranchArray = branch.getBranches();
                int n = cDOBranchArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOBranch child = cDOBranchArray[n2];
                    CDOBranchWrapper wrapper = new CDOBranchWrapper(repository, child.getPathName());
                    childrenList.addChild((Object)wrapper);
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(session);
                throw throwable;
            }
            IOUtil.close((Closeable)session);
        } else {
            super.fillChildren(context, parent, childrenList);
        }
    }

    public EList<Object> getElements(InternalProject project) {
        CDOProjectData data = (CDOProjectData)project.getProviderSpecificData();
        return data.getTransaction().getResourceSet().getResources();
    }

    public void handleLifecycle(ECPContainer context, InternalProvider.LifecycleEvent event) {
        super.handleLifecycle(context, event);
        if (context instanceof InternalProject) {
            InternalProject project = (InternalProject)context;
            switch (event) {
                case CREATE: {
                    this.createProject(project);
                    break;
                }
                case INIT: {
                    break;
                }
                case DISPOSE: {
                    this.disposeProject(project);
                    break;
                }
                case REMOVE: {
                    this.removeProject(project);
                    break;
                }
            }
        }
    }

    protected void createProject(InternalProject project) {
        String workspaceID = UUIDGenerator.DEFAULT.generate();
        project.getProperties().addProperty(PROP_WORKSPACE_ID, workspaceID);
        CDOProjectData projectData = CDOProvider.getProjectData(project);
        projectData.checkoutWorkspace();
        File folder = CDOProvider.getProjectFolder(project);
        PrintStream stream = null;
        try {
            try {
                stream = new PrintStream(new File(folder, "ecp.properties"));
                stream.println("project.name = " + project.getName());
            }
            catch (FileNotFoundException ex) {
                Activator.log(ex);
                throw new IllegalStateException("Retrieving project folder failed!", ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(stream);
            throw throwable;
        }
        IOUtil.close((java.io.Closeable)stream);
    }

    public ECPContainer getModelContext(Object element) {
        if (element instanceof CDOResource) {
            Set openProjects = this.getOpenProjects();
            for (InternalProject project : openProjects) {
                CDOProjectData projectData = (CDOProjectData)project.getProviderSpecificData();
                if (!projectData.getRootResource().getContents().contains(element)) continue;
                return project;
            }
        }
        return super.getModelContext(element);
    }

    protected CDOWorkspaceConfiguration createWorkspaceConfiguration(InternalProject project) {
        File folder = CDOProvider.getProjectFolder(project);
        folder.mkdirs();
        IDBStore localStore = this.createLocalStore(project, folder);
        CDOWorkspaceBase base = this.createWorkspaceBase(project, folder);
        CDORepositoryData remote = CDOProvider.getRepositoryData(project.getRepository());
        ECPProperties properties = project.getProperties();
        String branchPath = properties.getValue(PROP_BRANCH_PATH);
        String timeStamp = properties.getValue(PROP_TIME_STAMP);
        CDOWorkspaceConfiguration config = CDOWorkspaceUtil.createWorkspaceConfiguration();
        config.setLocalRepositoryName(folder.getName());
        config.setStore((IStore)localStore);
        config.setBase(base);
        config.setRemote((CDOSessionConfigurationFactory)remote);
        config.setBranchPath(branchPath == null ? "MAIN" : branchPath);
        config.setTimeStamp(timeStamp == null ? 0L : Long.parseLong(timeStamp));
        return config;
    }

    protected CDOWorkspaceBase createWorkspaceBase(InternalProject project, File folder) {
        File base = new File(folder, "base");
        base.mkdirs();
        return CDOWorkspaceUtil.createFolderWorkspaceBase((File)base);
    }

    protected IDBStore createLocalStore(InternalProject project, File folder) {
        File local = new File(folder, "local");
        local.mkdirs();
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL("jdbc:h2:" + new File(local, "local").getAbsolutePath());
        IMappingStrategy mappingStrategy = CDODBUtil.createHorizontalMappingStrategy((boolean)false, (boolean)false);
        H2Adapter dbAdapter = new H2Adapter();
        IDBConnectionProvider dbConnectionProvider = DBUtil.createConnectionProvider((DataSource)dataSource);
        return CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)dbAdapter, (IDBConnectionProvider)dbConnectionProvider);
    }

    protected void disposeProject(InternalProject project) {
        CDOProjectData data = (CDOProjectData)project.getProviderSpecificData();
        data.dispose();
    }

    protected void removeProject(InternalProject project) {
        File folder = CDOProvider.getProjectFolder(project);
        if (folder.exists() && !folder.delete()) {
            folder.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CDORepositoryData getRepositoryData(InternalRepository repository) {
        InternalRepository internalRepository = repository;
        synchronized (internalRepository) {
            CDORepositoryData data = (CDORepositoryData)repository.getProviderSpecificData();
            if (data == null) {
                data = new CDORepositoryData(repository);
                repository.setProviderSpecificData((Object)data);
            }
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CDOProjectData getProjectData(InternalProject project) {
        InternalProject internalProject = project;
        synchronized (internalProject) {
            CDOProjectData data = (CDOProjectData)project.getProviderSpecificData();
            if (data == null) {
                data = new CDOProjectData(project);
                project.setProviderSpecificData((Object)data);
            }
            return data;
        }
    }

    public static File getProjectFolder(InternalProject project) {
        String workspaceID = project.getProperties().getValue(PROP_WORKSPACE_ID);
        return new File(Activator.getInstance().getStateLocation().toFile(), workspaceID);
    }

    public void delete(InternalProject project, Collection<Object> objects) {
        CDOResource cdoResource = CDOProvider.getProjectData(project).getRootResource();
        cdoResource.getContents().removeAll(objects);
    }

    public void cloneProject(InternalProject projectToClone, InternalProject targetProject) {
        throw new UnsupportedOperationException();
    }

    public Notifier getRoot(InternalProject project) {
        CDOProjectData data = (CDOProjectData)project.getProviderSpecificData();
        if (data != null) {
            return data.getRootResource();
        }
        return null;
    }

    public boolean isThreadSafe() {
        return true;
    }
}

