/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.conn.gmf;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.elk.conn.gmf.ApplyLayoutRequest;
import org.eclipse.elk.conn.gmf.GmfLayoutCommand;
import org.eclipse.elk.core.math.ElkMath;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.core.util.WrappedException;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.ElkShape;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class GmfLayoutEditPolicy
extends AbstractEditPolicy {
    private Map<ElkEdgeSection, PointList> pointListMap = new HashMap<ElkEdgeSection, PointList>();
    private static final int SOURCE_LOCATION = 85;
    private static final int MIDDLE_LOCATION = 50;
    private static final int TARGET_LOCATION = 15;
    private static final String SPLINE_CONNECTION = "org.eclipse.elk.core.model.gmf.figures.SplineConnection";

    public boolean understandsRequest(Request req) {
        return "apply layout".equals(req.getType());
    }

    public Command getCommand(Request request) {
        if ("apply layout".equals(request.getType())) {
            if (request instanceof ApplyLayoutRequest) {
                ApplyLayoutRequest layoutRequest = (ApplyLayoutRequest)request;
                IGraphicalEditPart hostEditPart = (IGraphicalEditPart)this.getHost();
                GmfLayoutCommand command = new GmfLayoutCommand(hostEditPart.getEditingDomain(), "Automatic Layout", (IAdaptable)new EObjectAdapter((EObject)((View)hostEditPart.getModel())));
                double scale = layoutRequest.getScale();
                for (Pair<ElkGraphElement, GraphicalEditPart> layoutPair : layoutRequest.getElements()) {
                    if (layoutPair.getFirst() instanceof ElkNode) {
                        this.addShapeLayout(command, (ElkShape)layoutPair.getFirst(), (GraphicalEditPart)layoutPair.getSecond(), scale);
                        continue;
                    }
                    if (layoutPair.getFirst() instanceof ElkPort) {
                        this.addShapeLayout(command, (ElkShape)((ElkPort)layoutPair.getFirst()), (GraphicalEditPart)layoutPair.getSecond(), scale);
                        continue;
                    }
                    if (layoutPair.getFirst() instanceof ElkEdge) {
                        this.addEdgeLayout(command, (ElkEdge)layoutPair.getFirst(), (ConnectionEditPart)layoutPair.getSecond(), scale);
                        continue;
                    }
                    if (!(layoutPair.getFirst() instanceof ElkLabel)) continue;
                    this.addLabelLayout(command, (ElkLabel)layoutPair.getFirst(), (GraphicalEditPart)layoutPair.getSecond(), scale);
                }
                command.setObliqueRouting(true);
                this.pointListMap.clear();
                return new ICommandProxy((ICommand)command);
            }
            return null;
        }
        return super.getCommand(request);
    }

    private void addShapeLayout(GmfLayoutCommand command, ElkShape elkShape, GraphicalEditPart editPart, double scale) {
        View view = (View)editPart.getModel();
        Point newLocation = new Point((int)(elkShape.getX() * scale), (int)(elkShape.getY() * scale));
        Object oldx = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        Object oldy = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        if (oldx != null && oldy != null && newLocation.x == (Integer)oldx && newLocation.y == (Integer)oldy) {
            newLocation = null;
        }
        Dimension newSize = new Dimension((int)(elkShape.getWidth() * scale), (int)(elkShape.getHeight() * scale));
        Object oldWidth = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        Object oldHeight = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        if (oldWidth != null && oldHeight != null && newSize.width == (Integer)oldWidth && newSize.height == (Integer)oldHeight) {
            newSize = null;
        }
        if (newLocation != null || newSize != null) {
            command.addShapeLayout(view, newLocation, newSize);
        }
    }

    private void addEdgeLayout(GmfLayoutCommand command, ElkEdge elkEdge, ConnectionEditPart connectionEditPart, double scale) {
        if (connectionEditPart.getSource() != null && connectionEditPart.getTarget() != null) {
            SlidableAnchor targetAnchor;
            SlidableAnchor sourceAnchor;
            INodeEditPart sourceEditPart = (INodeEditPart)connectionEditPart.getSource();
            if (sourceEditPart instanceof ConnectionEditPart) {
                sourceAnchor = new SlidableAnchor(sourceEditPart.getFigure());
            } else {
                KVector sourceRel = this.getRelativeSourcePoint(elkEdge);
                sourceAnchor = new SlidableAnchor(sourceEditPart.getFigure(), new PrecisionPoint(sourceRel.x, sourceRel.y));
            }
            String sourceTerminal = sourceEditPart.mapConnectionAnchorToTerminal((ConnectionAnchor)sourceAnchor);
            INodeEditPart targetEditPart = (INodeEditPart)connectionEditPart.getTarget();
            if (targetEditPart instanceof ConnectionEditPart) {
                targetAnchor = new SlidableAnchor(targetEditPart.getFigure());
            } else {
                KVector targetRel = this.getRelativeTargetPoint(elkEdge);
                targetAnchor = new SlidableAnchor(targetEditPart.getFigure(), new PrecisionPoint(targetRel.x, targetRel.y));
            }
            String targetTerminal = targetEditPart.mapConnectionAnchorToTerminal((ConnectionAnchor)targetAnchor);
            PointList bendPoints = this.getBendPoints(elkEdge, connectionEditPart.getFigure(), scale);
            if (sourceEditPart instanceof ConnectionEditPart || targetEditPart instanceof ConnectionEditPart) {
                while (bendPoints.size() > 2) {
                    bendPoints.removePoint(1);
                }
            }
            KVectorChain junctionPoints = (KVectorChain)elkEdge.getProperty(CoreOptions.JUNCTION_POINTS);
            String serializedJP = null;
            if (junctionPoints != null) {
                for (KVector point : junctionPoints) {
                    ElkUtil.toAbsolute((KVector)point, (ElkNode)elkEdge.getContainingNode());
                }
                serializedJP = junctionPoints.toString();
            }
            command.addEdgeLayout((Edge)connectionEditPart.getModel(), bendPoints, sourceTerminal, targetTerminal, serializedJP);
        }
    }

    private KVector getRelativeSourcePoint(ElkEdge edge) {
        ElkConnectableShape sourceShape = (ElkConnectableShape)edge.getSources().get(0);
        ElkEdgeSection edgeSection = (ElkEdgeSection)edge.getSections().get(0);
        KVector sourcePoint = new KVector(edgeSection.getStartX(), edgeSection.getStartY());
        ElkUtil.toAbsolute((KVector)sourcePoint, (ElkNode)edge.getContainingNode());
        ElkUtil.toRelative((KVector)sourcePoint, (ElkNode)ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)sourceShape));
        if (sourceShape instanceof ElkPort) {
            ElkPort sourcePort = (ElkPort)sourceShape;
            sourcePoint.x = sourcePort.getWidth() <= 0.0 ? 0.0 : (sourcePoint.x - sourcePort.getX()) / sourcePort.getWidth();
            sourcePoint.y = sourcePort.getHeight() <= 0.0 ? 0.0 : (sourcePoint.y - sourcePort.getY()) / sourcePort.getHeight();
        } else {
            sourcePoint.x = sourceShape.getWidth() <= 0.0 ? 0.0 : (sourcePoint.x /= sourceShape.getWidth());
            sourcePoint.y = sourceShape.getHeight() <= 0.0 ? 0.0 : (sourcePoint.y /= sourceShape.getHeight());
        }
        return sourcePoint.bound(0.0, 0.0, 1.0, 1.0);
    }

    private KVector getRelativeTargetPoint(ElkEdge edge) {
        ElkConnectableShape targetShape = (ElkConnectableShape)edge.getTargets().get(0);
        ElkEdgeSection edgeSection = (ElkEdgeSection)edge.getSections().get(0);
        KVector targetPoint = new KVector(edgeSection.getEndX(), edgeSection.getEndY());
        ElkUtil.toAbsolute((KVector)targetPoint, (ElkNode)edge.getContainingNode());
        ElkUtil.toRelative((KVector)targetPoint, (ElkNode)ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)targetShape));
        if (targetShape instanceof ElkPort) {
            ElkPort targetPort = (ElkPort)targetShape;
            targetPoint.x = targetPort.getWidth() <= 0.0 ? 0.0 : (targetPoint.x - targetPort.getX()) / targetPort.getWidth();
            targetPoint.y = targetPort.getHeight() <= 0.0 ? 0.0 : (targetPoint.y - targetPort.getY()) / targetPort.getHeight();
        } else {
            targetPoint.x = targetShape.getWidth() <= 0.0 ? 0.0 : (targetPoint.x /= targetShape.getWidth());
            targetPoint.y = targetShape.getHeight() <= 0.0 ? 0.0 : (targetPoint.y /= targetShape.getHeight());
        }
        return targetPoint.bound(0.0, 0.0, 1.0, 1.0);
    }

    private void addLabelLayout(GmfLayoutCommand command, ElkLabel klabel, GraphicalEditPart labelEditPart, double scale) {
        ElkGraphElement parent = klabel.getParent();
        if (parent instanceof ElkNode || parent instanceof ElkPort) {
            View view = (View)labelEditPart.getModel();
            int xpos = (int)(klabel.getX() * scale);
            int ypos = (int)(klabel.getY() * scale);
            Object oldx = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
            Object oldy = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
            if (oldx == null || oldy == null || xpos != (Integer)oldx || ypos != (Integer)oldy) {
                command.addShapeLayout(view, new Point(xpos, ypos), null);
            }
            return;
        }
        if (parent instanceof ElkEdge) {
            int fromEnd;
            Rectangle targetBounds = new Rectangle(labelEditPart.getFigure().getBounds());
            targetBounds.x = (int)(klabel.getX() * scale);
            targetBounds.y = (int)(klabel.getY() * scale);
            ConnectionEditPart connectionEditPart = (ConnectionEditPart)labelEditPart.getParent();
            PointList bendPoints = this.getBendPoints((ElkEdge)parent, connectionEditPart.getFigure(), scale);
            EObject modelElement = connectionEditPart.getNotationView().getElement();
            EdgeLabelPlacement labelPlacement = (EdgeLabelPlacement)klabel.getProperty(CoreOptions.EDGE_LABELS_PLACEMENT);
            if (modelElement instanceof EReference && labelPlacement == EdgeLabelPlacement.TAIL) {
                bendPoints = bendPoints.getCopy();
                bendPoints.reverse();
            }
            int keyPoint = 4;
            if (labelEditPart instanceof LabelEditPart) {
                keyPoint = ((LabelEditPart)labelEditPart).getKeyPoint();
            }
            switch (keyPoint) {
                case 2: {
                    fromEnd = 85;
                    break;
                }
                case 3: {
                    fromEnd = 15;
                    break;
                }
                default: {
                    fromEnd = 50;
                }
            }
            Point refPoint = PointListUtilities.calculatePointRelativeToLine((PointList)bendPoints, (int)0, (int)fromEnd, (boolean)true);
            Point normalPoint = GmfLayoutEditPolicy.offsetFromRelativeCoordinate(targetBounds, bendPoints, refPoint);
            if (normalPoint != null) {
                command.addShapeLayout((View)labelEditPart.getModel(), normalPoint, null);
            }
        }
    }

    private PointList getBendPoints(ElkEdge edge, IFigure edgeFigure, double scale) {
        ElkEdgeSection edgeSection = (ElkEdgeSection)edge.getSections().get(0);
        PointList pointList = this.pointListMap.get(edgeSection);
        if (pointList == null) {
            KVectorChain bendPoints = ElkUtil.createVectorChain((ElkEdgeSection)edgeSection);
            boolean approx = GmfLayoutEditPolicy.handleSplineConnection(edgeFigure, (EdgeRouting)edge.getProperty(CoreOptions.EDGE_ROUTING));
            if (approx && bendPoints.size() >= 1) {
                bendPoints = ElkMath.approximateBezierSpline((KVectorChain)bendPoints);
            }
            bendPoints.scale(scale);
            pointList = new PointList(bendPoints.size() + 2);
            for (KVector bendPoint : bendPoints) {
                pointList.addPoint((int)bendPoint.x, (int)bendPoint.y);
            }
            this.pointListMap.put(edgeSection, pointList);
        }
        return pointList;
    }

    private static boolean handleSplineConnection(IFigure edgeFigure, EdgeRouting edgeRouting) {
        boolean isSC;
        Class<?> clazz = edgeFigure.getClass();
        do {
            String canonicalName;
            isSC = (canonicalName = clazz.getCanonicalName()) != null && canonicalName.equals(SPLINE_CONNECTION);
            clazz = clazz.getSuperclass();
        } while (!isSC && clazz != null);
        if (isSC) {
            clazz = edgeFigure.getClass();
            try {
                if (edgeRouting == EdgeRouting.SPLINES) {
                    clazz.getMethod("setSplineMode", Integer.TYPE).invoke((Object)edgeFigure, 1);
                } else {
                    clazz.getMethod("setSplineMode", Integer.TYPE).invoke((Object)edgeFigure, 0);
                }
                return false;
            }
            catch (Exception exception) {
                throw new WrappedException((Throwable)exception);
            }
        }
        return edgeRouting == EdgeRouting.SPLINES;
    }

    public static Point offsetFromRelativeCoordinate(Rectangle bounds, PointList points, Point therefPoint) {
        Point refPoint = therefPoint;
        if (refPoint == null) {
            refPoint = points.getFirstPoint();
        }
        bounds.translate(bounds.width / 2, bounds.height / 2);
        Point offset = new Point(bounds.x - refPoint.x, bounds.y - refPoint.y);
        if (points.size() == 1) {
            return offset;
        }
        if (points.size() >= 2) {
            int segIndex = PointListUtilities.findNearestLineSegIndexOfPoint((PointList)points, (Point)refPoint);
            List segmentsList = PointListUtilities.getLineSegments((PointList)points);
            segIndex = segIndex <= 0 ? 0 : (segIndex > segmentsList.size() ? segmentsList.size() - 1 : --segIndex);
            LineSeg segment = (LineSeg)segmentsList.get(segIndex);
            Point normalOffset = null;
            if (segment.isHorizontal()) {
                if (segment.getOrigin().x > segment.getTerminus().x) {
                    normalOffset = offset.getNegated();
                    return normalOffset;
                }
                normalOffset = offset;
                return normalOffset;
            }
            if (segment.isVertical()) {
                if (segment.getOrigin().y < segment.getTerminus().y) {
                    normalOffset = offset.scale(-1.0, 1.0).transpose();
                    return normalOffset;
                }
                normalOffset = offset.scale(1.0, -1.0).transpose();
                return normalOffset;
            }
            Point offsetRefPoint = refPoint.getTranslated(offset);
            LineSeg parallelSeg = segment.getParallelLineSegThroughPoint(offsetRefPoint);
            Point p1 = parallelSeg.perpIntersect(refPoint.x, refPoint.y);
            double dx = p1.getDistance(offsetRefPoint) * (double)(p1.x > offsetRefPoint.x ? -1 : 1);
            double dy = p1.getDistance(refPoint) * (double)(p1.y < refPoint.y ? -1 : 1);
            PrecisionPoint orth = new PrecisionPoint(dx, dy);
            if (segment.getOrigin().x > segment.getTerminus().x) {
                orth = orth.scale(-1.0, -1.0);
            }
            return orth;
        }
        return null;
    }
}

